/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.graph;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TShape;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;

public class TNode
extends TShape {
    private static final long serialVersionUID = 1L;
    private TGraph graph;
    private String label;
    private LinkedList<TEdge> outgoingEdges = new LinkedList();
    private LinkedList<TEdge> incomingEdges = new LinkedList();

    public TNode(int id, TGraph graph, String label) {
        this(id, graph);
        this.label = label;
    }

    public TNode(int id, TGraph graph) {
        super(id);
        this.graph = graph;
    }

    public String toString() {
        if (this.label == null || this.label.length() == 0) {
            return "n_" + this.id;
        }
        return "n_" + this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public Iterable<TNode> getParents() {
        return new Iterable<TNode>(){

            @Override
            public Iterator<TNode> iterator() {
                final Iterator<TEdge> edgesIter = TNode.this.getIncomingEdges().iterator();
                return new Iterator<TNode>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public TNode next() {
                        return ((TEdge)((Object)edgesIter.next())).getSource();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public TNode getParent() {
        List<TEdge> edges = this.getIncomingEdges();
        if (edges.isEmpty()) {
            return null;
        }
        return edges.get(0).getSource();
    }

    public LinkedList<TNode> getChildrenCopy() {
        LinkedList<TNode> children = new LinkedList<TNode>();
        for (TEdge iEdge : this.getOutgoingEdges()) {
            children.add(iEdge.getTarget());
        }
        return children;
    }

    public Iterable<TNode> getChildren() {
        return new Iterable<TNode>(){

            @Override
            public Iterator<TNode> iterator() {
                final Iterator<TEdge> edgesIter = TNode.this.getOutgoingEdges().iterator();
                return new Iterator<TNode>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public TNode next() {
                        return ((TEdge)((Object)edgesIter.next())).getTarget();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public List<TEdge> getOutgoingEdges() {
        if (this.outgoingEdges == null) {
            this.outgoingEdges = new LinkedList();
        }
        return this.outgoingEdges;
    }

    public List<TEdge> getIncomingEdges() {
        if (this.incomingEdges == null) {
            this.incomingEdges = new LinkedList();
        }
        return this.incomingEdges;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addChild(TNode child) {
        TEdge newEdge = new TEdge(this, child);
        newEdge.setProperty(InternalProperties.DUMMY, true);
        this.graph.getEdges().add(newEdge);
        this.getOutgoingEdges().add(newEdge);
        child.getIncomingEdges().add(newEdge);
    }

    public boolean isLeaf() {
        return this.getOutgoingEdges().isEmpty();
    }
}

