/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.internal.converter;

import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.services.diagram.internal.converter.ISiriusDiagramElementConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramEdgeConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramGradientNodeConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramImageNodeConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramListElementNodeConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramListNodeConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramSquareNodeConverter;
import org.eclipse.sirius.viewpoint.Style;

public class SiriusDiagramElementSwitch {
    protected ISiriusDiagramElementConverter getDefaultValue() {
        return null;
    }

    public ISiriusDiagramElementConverter doSwitch(DDiagramElement dDiagramElement) {
        ISiriusDiagramElementConverter result = this.getDefaultValue();
        switch (dDiagramElement.eClass().getClassifierID()) {
            case 11: {
                if (!(dDiagramElement instanceof DNode)) break;
                result = this.caseDNode((DNode)dDiagramElement);
                break;
            }
            case 13: {
                if (!(dDiagramElement instanceof DNodeContainer)) break;
                result = this.caseDNodeContainer((DNodeContainer)dDiagramElement);
                break;
            }
            case 14: {
                if (!(dDiagramElement instanceof DNodeList)) break;
                result = this.caseDNodeList((DNodeList)dDiagramElement);
                break;
            }
            case 15: {
                if (!(dDiagramElement instanceof DNodeListElement)) break;
                result = this.caseDNodeListElement((DNodeListElement)dDiagramElement);
                break;
            }
            case 16: {
                if (!(dDiagramElement instanceof DEdge)) break;
                result = this.caseDEdge((DEdge)dDiagramElement);
                break;
            }
            default: {
                result = this.getDefaultValue();
            }
        }
        return result;
    }

    public ISiriusDiagramElementConverter caseDNode(DNode dNode) {
        Style style = dNode.getStyle();
        if (style instanceof WorkspaceImage) {
            return new SiriusDiagramImageNodeConverter(dNode);
        }
        if (style instanceof Square) {
            return new SiriusDiagramSquareNodeConverter((AbstractDNode)dNode);
        }
        throw new IllegalArgumentException();
    }

    public ISiriusDiagramElementConverter caseDNodeContainer(DNodeContainer dNodeContainer) {
        Style style = dNodeContainer.getStyle();
        if (style instanceof FlatContainerStyle) {
            return new SiriusDiagramGradientNodeConverter(dNodeContainer);
        }
        throw new IllegalArgumentException();
    }

    public ISiriusDiagramElementConverter caseDNodeList(DNodeList dNodeList) {
        return new SiriusDiagramListNodeConverter(dNodeList);
    }

    public ISiriusDiagramElementConverter caseDNodeListElement(DNodeListElement dNodeListElement) {
        return new SiriusDiagramListElementNodeConverter(dNodeListElement);
    }

    public ISiriusDiagramElementConverter caseDEdge(DEdge dEdge) {
        return new SiriusDiagramEdgeConverter(dEdge);
    }
}

