/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public final class RepresentationDescriptionEPackagesField {
    private static final String EPACKAGES_FIELD = "ePackages";
    private static final int COMPLEXITY = 1;

    private RepresentationDescriptionEPackagesField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(EPACKAGES_FIELD).argument(SiriusGraphQLPaginationArguments.build()).type((GraphQLOutputType)new GraphQLTypeReference("RepresentationDescriptionEPackageConnection")).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(RepresentationDescriptionEPackagesField.getEPackagesDataFetcher()).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getEPackagesDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> Optional.of(environment.getSource()).filter(RepresentationDescription.class::isInstance).map(RepresentationDescription.class::cast).map(representationDescription -> {
            EList p = representationDescription.getMetamodel();
            return p;
        }).orElseGet(ArrayList::new), RepresentationDescriptionEPackagesField::computeEPackageCursor);
    }

    private static String computeEPackageCursor(EPackage ePackage) {
        String unEncodedCursor = ePackage.getNsURI();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }
}

