/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.internal;

import java.util.Arrays;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.servlets.HeaderFilter;
import org.eclipse.sirius.server.api.ISiriusServerConfigurator;
import org.eclipse.sirius.server.internal.Messages;

public class SiriusServerHeaderConfigurator
implements ISiriusServerConfigurator {
    private static final String ALLOWED_METHODS = "org.eclipse.sirius.server.cors.allowed.methods";
    private static final String ALLOWED_HEADERS = "org.eclipse.sirius.server.cors.allowed.headers";
    private static final String ALLOWED_ORIGINS = "org.eclipse.sirius.server.cors.allowed.origins";
    private static final String ALLOW_CORS = "org.eclipse.sirius.server.cors.enabled";
    private static final String HEADER_CONFIG = "headerConfig";
    private static final String ALL_PATH = "/*";

    @Override
    public void configure(Server server) {
        this.configureHeaders(server.getHandler());
    }

    private void configureHeaders(Handler handler) {
        if (handler instanceof HandlerCollection) {
            HandlerCollection handlerCollection = (HandlerCollection)handler;
            Arrays.stream(handlerCollection.getHandlers()).forEach(this::configureHeaders);
        } else if (handler instanceof ServletContextHandler) {
            ServletContextHandler servletContextHandler = (ServletContextHandler)handler;
            this.configureCORS(servletContextHandler);
            this.configureAdditionalHeaders(servletContextHandler);
        }
    }

    private void configureCORS(ServletContextHandler servletContextHandler) {
        boolean allowCors = Boolean.parseBoolean(System.getProperty(ALLOW_CORS));
        if (allowCors) {
            String allowedMethods;
            String allowedHeaders;
            FilterHolder cors = new FilterHolder();
            String allowedOrigins = System.getProperty(ALLOWED_ORIGINS);
            if (allowedOrigins != null) {
                cors.setInitParameter("allowedOrigins", allowedOrigins);
            }
            if ((allowedHeaders = System.getProperty(ALLOWED_HEADERS)) != null) {
                cors.setInitParameter("allowedHeaders", allowedHeaders);
            }
            if ((allowedMethods = System.getProperty(ALLOWED_METHODS)) != null) {
                cors.setInitParameter("allowedMethods", allowedMethods);
            }
            cors.setFilter((Filter)new CrossOriginFilter());
            servletContextHandler.addFilter(cors, ALL_PATH, EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC, DispatcherType.INCLUDE));
        }
    }

    private void configureAdditionalHeaders(ServletContextHandler servletContextHandler) {
        FilterHolder headerFilterHolder = new FilterHolder();
        headerFilterHolder.setInitParameter(HEADER_CONFIG, Messages.SiriusServerConfigurator_headerConfig);
        headerFilterHolder.setFilter((Filter)new HeaderFilter());
    }
}

