/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.emf.internal.schema;

import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypeCustomizer;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypesProvider;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLFilterStatus;
import org.eclipse.sirius.services.graphql.emf.internal.schema.EClassInterfaceTypeBuilder;
import org.eclipse.sirius.services.graphql.emf.internal.schema.EClassObjectTypeBuilder;
import org.eclipse.sirius.services.graphql.emf.internal.schema.ExtendedEClassTypesBuilder;
import org.eclipse.sirius.services.graphql.emf.internal.schema.INameProvider;

public class EPackageTypesProvider
implements ISiriusGraphQLTypesProvider {
    private static final String IMPL_SUFFIX = "Impl";
    private EPackage ePackage;
    private HashMap<EDataType, GraphQLOutputType> eDataTypeToOutputTypeCache = new HashMap();
    private Function<EClassifier, SiriusGraphQLFilterStatus> eClassifierFilter = eClassifier -> {
        if (EcorePackage.eINSTANCE.getEObject().equals(eClassifier)) {
            return SiriusGraphQLFilterStatus.REJECT;
        }
        return SiriusGraphQLFilterStatus.KEEP;
    };
    private INameProvider nameProvider = (anEClass, nameKind) -> {
        if (this.isExtendedClass(anEClass) && INameProvider.NameKind.TYPE.equals((Object)nameKind)) {
            return String.valueOf(anEClass.getName()) + IMPL_SUFFIX;
        }
        return anEClass.getName();
    };
    private Function<EStructuralFeature, SiriusGraphQLFilterStatus> eStructuralFeatureFilter = eStructuralFeature -> {
        boolean shouldBeRejected = EcorePackage.eINSTANCE.getEJavaClass().equals(eStructuralFeature.getEType());
        shouldBeRejected = shouldBeRejected || EcorePackage.eINSTANCE.getEJavaObject().equals(eStructuralFeature.getEType());
        shouldBeRejected = shouldBeRejected || EcorePackage.eINSTANCE.getEFeatureMap().equals(eStructuralFeature.getEType());
        boolean bl = shouldBeRejected = shouldBeRejected || EcorePackage.eINSTANCE.getEFeatureMapEntry().equals(eStructuralFeature.getEType());
        if (shouldBeRejected) {
            return SiriusGraphQLFilterStatus.REJECT;
        }
        return SiriusGraphQLFilterStatus.KEEP;
    };

    public EPackageTypesProvider(EPackage ePackage) {
        this.ePackage = ePackage;
    }

    public EPackageTypesProvider cache(HashMap<EDataType, GraphQLOutputType> eDataTypeToOutputTypeCache) {
        this.eDataTypeToOutputTypeCache = eDataTypeToOutputTypeCache;
        return this;
    }

    public EPackageTypesProvider eClassifierFilter(Function<EClassifier, SiriusGraphQLFilterStatus> eClassifierFilter) {
        this.eClassifierFilter = eClassifierFilter;
        return this;
    }

    public EPackageTypesProvider nameProvider(INameProvider nameProvider) {
        this.nameProvider = nameProvider;
        return this;
    }

    public Set<GraphQLType> getTypes(ISiriusGraphQLTypeCustomizer customizer) {
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        Stream<EClass> eClassStream = this.ePackage.getEClassifiers().stream().filter(eClassifier -> SiriusGraphQLFilterStatus.KEEP.equals((Object)this.eClassifierFilter.apply((EClassifier)eClassifier))).filter(EClass.class::isInstance).map(EClass.class::cast);
        eClassStream.forEach(eClass -> {
            if (eClass.isAbstract() || eClass.isInterface()) {
                types.add(this.getInterfaceType((EClass)eClass));
            } else if (this.isExtendedClass((EClass)eClass)) {
                types.addAll(this.getExtendedClassTypes((EClass)eClass));
            } else {
                types.add(this.getEClassType((EClass)eClass));
            }
        });
        return types;
    }

    private GraphQLType getInterfaceType(EClass eClass) {
        return new EClassInterfaceTypeBuilder(eClass, this.eDataTypeToOutputTypeCache).nameProvider(this.nameProvider).eStructuralFeatureFilter(this.eStructuralFeatureFilter).getType();
    }

    private Set<GraphQLType> getExtendedClassTypes(EClass eClass) {
        return new ExtendedEClassTypesBuilder(eClass, this.eDataTypeToOutputTypeCache).nameProvider(this.nameProvider).eStructuralFeatureFilter(this.eStructuralFeatureFilter).getTypes();
    }

    private GraphQLType getEClassType(EClass eClass) {
        return new EClassObjectTypeBuilder(eClass, this.eDataTypeToOutputTypeCache).nameProvider(this.nameProvider).eStructuralFeatureFilter(this.eStructuralFeatureFilter).getType();
    }

    private boolean isExtendedClass(EClass eClass) {
        return eClass.getEPackage().getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(anEClass -> anEClass.getESuperTypes().contains((Object)eClass)).findFirst().isPresent();
    }
}

