/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractInteractionFrameValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.OperandResizeValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;

public class CombinedFragmentResizeValidator
extends AbstractInteractionFrameValidator {
    private Operand impactedOperand;
    private OperandResizeValidator impactedOperandResizeValidator;

    protected CombinedFragmentResizeValidator(CombinedFragment combinedFragment, RequestQuery requestQuery) {
        super((AbstractFrame)combinedFragment, requestQuery);
        Preconditions.checkArgument((requestQuery.isResizeFromTop() || requestQuery.isResizeFromBottom() ? 1 : 0) != 0);
        this.defaultFrameHeight = 90;
        if (requestQuery.isResizeFromTop()) {
            this.impactedOperand = combinedFragment.getFirstOperand();
        } else if (requestQuery.isResizeFromBottom()) {
            this.impactedOperand = combinedFragment.getLastOperand();
        }
        Preconditions.checkArgument((this.impactedOperand != null ? 1 : 0) != 0);
        this.impactedOperandResizeValidator = new OperandResizeValidator(this.impactedOperand, requestQuery);
    }

    @Override
    protected Collection<ISequenceEvent> getFinalParents(Collection<Lifeline> coveredLifelines) {
        return this.frame.computeParentEvents();
    }

    @Override
    protected void validate() {
        super.validate();
        if (!this.getRequestQuery().isResizeFromBottom() || this.getRequestQuery().getLogicalDelta().height <= 0) {
            this.impactedOperandResizeValidator.validate();
            this.valid = this.valid && this.impactedOperandResizeValidator.isValid();
        }
    }

    @Override
    protected boolean canExpand() {
        return true;
    }

    @Override
    protected Range computeExpansionZone() {
        Range expansionZone = Range.emptyRange();
        if (this.getRequestQuery().isResizeFromBottom() && this.getRequestQuery().getLogicalDelta().height > 0) {
            expansionZone = new Range(this.initialRange.getUpperBound(), this.finalRange.getUpperBound());
        }
        return expansionZone;
    }
}

