/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.user;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class UserViewpointsField {
    private static final String VIEWPOINTS_FIELD = "viewpoints";
    private static final int COMPLEXITY = 1;

    private UserViewpointsField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(VIEWPOINTS_FIELD).type((GraphQLOutputType)new GraphQLTypeReference("UserViewpointConnection")).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(UserViewpointsField.getViewpointsDataFetcher()).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getViewpointsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> {
            Set viewpointSet = ViewpointRegistry.getInstance().getViewpoints();
            ArrayList viewpoints = new ArrayList(viewpointSet);
            viewpoints.sort((v1, v2) -> v1.getName().compareTo(v2.getName()));
            return viewpoints;
        }, UserViewpointsField::computeViewpointCursor);
    }

    private static String computeViewpointCursor(Viewpoint viewpoint) {
        String unEncodedCursor = EcoreUtil.getURI((EObject)viewpoint).toString();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }
}

