/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal.services.workflow;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.workflow.ActivityDescription;
import org.eclipse.sirius.workflow.PageDescription;
import org.eclipse.sirius.workflow.SectionDescription;
import org.eclipse.sirius.workflow.WorkflowDescription;

public final class WorkflowHelper {
    private final Session session;

    public static WorkflowHelper on(Session session) {
        return new WorkflowHelper(Objects.requireNonNull(session));
    }

    private WorkflowHelper(Session session) {
        this.session = session;
    }

    public Stream<PageDescription> getPageDescriptions() {
        return this.getWorkflowDescriptions().flatMap(w -> w.getPages().stream());
    }

    public Stream<WorkflowDescription> getWorkflowDescriptions() {
        return this.session.getSelectedViewpoints(true).stream().map(viewpoint -> new EObjectQuery((EObject)viewpoint).getFirstAncestorOfType(DescriptionPackage.Literals.GROUP)).filter(Option::some).map(Option::get).filter(Group.class::isInstance).map(Group.class::cast).flatMap(group -> group.getExtensions().stream()).filter(WorkflowDescription.class::isInstance).map(WorkflowDescription.class::cast);
    }

    public Optional<PageDescription> findPageById(String pageIdentifier) {
        return this.findById(this.getPageDescriptions(), pageIdentifier);
    }

    public Optional<SectionDescription> findSectionById(String pageId, String sectionId) {
        return this.findPageById(pageId).flatMap(page -> this.findById((Collection)page.getSections(), sectionId));
    }

    public Optional<ActivityDescription> findActivityById(String pageId, String sectionId, String activityId) {
        return this.findSectionById(pageId, sectionId).flatMap(section -> this.findById((Collection)section.getActivities(), activityId));
    }

    private <T extends IdentifiedElement> Optional<T> findById(Collection<T> candidates, String id) {
        return this.findById(candidates.stream(), id);
    }

    private <T extends IdentifiedElement> Optional<T> findById(Stream<T> candidates, String id) {
        return candidates.filter(elt -> Objects.equals(elt.getName(), id)).findFirst();
    }
}

