/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.IContainerMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.INodeMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.BestStyleDescriptionKey;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.BestStyleDescriptionRegistry;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.GetDefaultStyle;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public final class MappingWithInterpreterHelper {
    private BestStyleDescriptionRegistry bestStyleDescriptionRegistry;
    private StyleHelper styleHelper;
    private IInterpreter interpreter;

    public MappingWithInterpreterHelper(IInterpreter interpreter) {
        this.bestStyleDescriptionRegistry = new BestStyleDescriptionRegistry(interpreter);
        this.styleHelper = new StyleHelper(interpreter);
        this.interpreter = interpreter;
    }

    public void affectAndRefreshStyle(DiagramElementMapping mapping, DDiagramElement diagramElement, EObject semanticElement, EObject containerVariable, DDiagram parentDiagram) {
        Style currentStyle = diagramElement.getStyle();
        Style bestStyle = this.getBestStyle(mapping, semanticElement, (EObject)diagramElement, containerVariable, parentDiagram);
        this.styleHelper.setAndRefreshStyle(diagramElement, currentStyle, bestStyle);
    }

    @Deprecated
    public static void addDoneNode(AbstractNodeMapping nodeMapping, DSemanticDecorator node) {
        if (node instanceof NodeMapping) {
            NodeMappingHelper.addDoneNode((INodeMappingExt)nodeMapping, node);
        } else if (node instanceof ContainerMapping) {
            ContainerMappingWithInterpreterHelper.addDoneNode((IContainerMappingExt)nodeMapping, node);
        } else if (node instanceof NodeMappingImport) {
            MappingWithInterpreterHelper.addDoneNode((NodeMappingImport)nodeMapping, node);
        } else if (node instanceof ContainerMappingImport) {
            MappingWithInterpreterHelper.addDoneNode((ContainerMappingImport)nodeMapping, node);
        }
    }

    @Deprecated
    private static void addDoneNode(ContainerMappingImport containerMapping, DSemanticDecorator node) {
        ContainerMappingWithInterpreterHelper.addDoneNode((IContainerMappingExt)((Object)containerMapping), node);
        if (containerMapping.getImportedMapping() != null && containerMapping.getImportedMapping() != containerMapping) {
            MappingWithInterpreterHelper.addDoneNode(containerMapping.getImportedMapping(), node);
        }
    }

    @Deprecated
    private static void addDoneNode(NodeMappingImport nodeMapping, DSemanticDecorator node) {
        NodeMappingHelper.addDoneNode((INodeMappingExt)((Object)nodeMapping), node);
        if (nodeMapping.getImportedMapping() != null && nodeMapping.getImportedMapping() != nodeMapping) {
            MappingWithInterpreterHelper.addDoneNode(nodeMapping.getImportedMapping(), node);
        }
    }

    public Style getBestStyle(DiagramElementMapping mapping, EObject modelElement, EObject viewVariable, EObject containerVariable, DDiagram parentDiagram) {
        StyleDescription description = this.getBestStyleDescription(mapping, modelElement, viewVariable, containerVariable, parentDiagram);
        Style result = null;
        if (description != null) {
            result = this.styleHelper.createStyle(description);
        }
        if (mapping instanceof EdgeMappingImport) {
            EdgeMappingImport edgeMappingImport = (EdgeMappingImport)((Object)mapping);
            if (result == null && edgeMappingImport.getImportedMapping() != null && edgeMappingImport.getImportedMapping() != edgeMappingImport) {
                result = new MappingWithInterpreterHelper(this.interpreter).getBestStyle(mapping, modelElement, viewVariable, containerVariable, (DDiagram)new EObjectQuery(viewVariable).getParentDiagram().get());
            }
        }
        return result;
    }

    public StyleDescription getBestStyleDescription(DiagramElementMapping mapping, EObject modelElement, EObject viewVariable, EObject containerVariable, DDiagram parentDiagram) {
        BestStyleDescriptionKey bestStyleDescriptionKey = new BestStyleDescriptionKey(mapping, modelElement, viewVariable, containerVariable, parentDiagram);
        StyleDescription result = this.bestStyleDescriptionRegistry.get(bestStyleDescriptionKey);
        return result;
    }

    public static StyleDescription getDefaultStyleDescription(DiagramElementMapping mapping) {
        return (StyleDescription)new GetDefaultStyle().doSwitch((EObject)mapping);
    }
}

