/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.helper;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.business.internal.refresh.DTreeElementSynchronizerSpec;
import org.eclipse.sirius.tree.tools.internal.Messages;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class RefreshTreeElementTask
extends AbstractCommandTask {
    private EObject uniqueRefreshable;
    private Collection<DTreeElement> refreshablesList;
    private final IProgressMonitor monitor;

    public RefreshTreeElementTask(EObject objectToRefresh) {
        this(objectToRefresh, (IProgressMonitor)new NullProgressMonitor());
    }

    public RefreshTreeElementTask(EObject objectToRefresh, IProgressMonitor monitor) {
        this.uniqueRefreshable = objectToRefresh;
        this.monitor = monitor;
    }

    public RefreshTreeElementTask(Collection<DTreeElement> objectsToRefresh) {
        this(objectsToRefresh, (IProgressMonitor)new NullProgressMonitor());
    }

    public RefreshTreeElementTask(Collection<DTreeElement> objectsToRefresh, IProgressMonitor monitor) {
        this.refreshablesList = objectsToRefresh;
        this.monitor = monitor;
    }

    public void execute() {
        if (this.uniqueRefreshable instanceof DTree) {
            DialectManager.INSTANCE.refresh((DRepresentation)((DTree)this.uniqueRefreshable), this.monitor);
        }
        if (this.uniqueRefreshable instanceof DTreeElement) {
            this.refreshTreeElement((DTreeItem)this.uniqueRefreshable);
        }
        if (this.refreshablesList != null) {
            for (DTreeElement obj : this.refreshablesList) {
                if (obj instanceof DTree) {
                    DialectManager.INSTANCE.refresh((DRepresentation)((DTree)((Object)obj)), this.monitor);
                    continue;
                }
                if (!(obj instanceof DTreeElement)) continue;
                this.refreshTreeElement((DTreeItem)obj);
            }
        }
    }

    private void refreshTreeElement(DTreeItem treeElement) {
        DTree tree = TreeHelper.getTree((EObject)treeElement);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(tree.getTarget());
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)tree);
        DTreeElementSynchronizerSpec synchronizer = new DTreeElementSynchronizerSpec(interpreter, accessor);
        synchronizer.refreshItemAndChildren(treeElement);
    }

    public String getLabel() {
        return Messages.RefreshTreeElementTask_label;
    }
}

