/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.emf.internal.schema;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLFilterStatus;
import org.eclipse.sirius.services.graphql.emf.internal.schema.FieldsBuilder;
import org.eclipse.sirius.services.graphql.emf.internal.schema.INameProvider;

public class EClassObjectTypeBuilder {
    private EClass eClass;
    private HashMap<EDataType, GraphQLOutputType> eDataTypeToOutputTypeCache;
    private INameProvider nameProvider = (anEClass, nameKind) -> anEClass.getName();
    private Function<EStructuralFeature, SiriusGraphQLFilterStatus> eStructuralFeatureFilter;

    public EClassObjectTypeBuilder(EClass eClass, HashMap<EDataType, GraphQLOutputType> eDataTypeToOutputTypeCache) {
        this.eClass = eClass;
        this.eDataTypeToOutputTypeCache = eDataTypeToOutputTypeCache;
    }

    public EClassObjectTypeBuilder nameProvider(INameProvider nameProvider) {
        this.nameProvider = nameProvider;
        return this;
    }

    public EClassObjectTypeBuilder eStructuralFeatureFilter(Function<EStructuralFeature, SiriusGraphQLFilterStatus> eStructuralFeatureFilter) {
        this.eStructuralFeatureFilter = eStructuralFeatureFilter;
        return this;
    }

    public GraphQLObjectType getType() {
        GraphQLTypeReference[] interfaces = this.getInterfaces();
        return GraphQLObjectType.newObject().name(this.nameProvider.getName(this.eClass, INameProvider.NameKind.TYPE)).fields(new FieldsBuilder(this.eClass, this.eDataTypeToOutputTypeCache).eStructuralFeatureFilter(this.eStructuralFeatureFilter).getFields()).withInterfaces(interfaces).withInterface(new GraphQLTypeReference("EObject")).build();
    }

    private GraphQLTypeReference[] getInterfaces() {
        ArrayList eAllSuperTypes = new ArrayList(this.eClass.getEAllSuperTypes());
        Collections.reverse(eAllSuperTypes);
        return (GraphQLTypeReference[])eAllSuperTypes.stream().map(ENamedElement::getName).map(GraphQLTypeReference::new).toArray(GraphQLTypeReference[]::new);
    }
}

