/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.internal.actions;

import java.util.Optional;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.services.diagram.api.AbstractSiriusDiagramAction;
import org.eclipse.sirius.services.diagram.api.SiriusDiagramService;
import org.eclipse.sirius.services.diagram.api.actions.SiriusDiagramExecuteNodeCreationToolAction;
import org.eclipse.sirius.services.diagram.internal.actions.ISiriusDiagramActionHandler;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class SiriusDiagramExecuteNodeCreationToolActionHandler
implements ISiriusDiagramActionHandler {
    @Override
    public boolean canHandle(SiriusDiagramService diagramService, AbstractSiriusDiagramAction action) {
        return action instanceof SiriusDiagramExecuteNodeCreationToolAction;
    }

    @Override
    public void handle(SiriusDiagramService diagramService, AbstractSiriusDiagramAction action) {
        if (action instanceof SiriusDiagramExecuteNodeCreationToolAction) {
            SiriusDiagramExecuteNodeCreationToolAction executeNodeCreationToolAction = (SiriusDiagramExecuteNodeCreationToolAction)action;
            DiagramDescription diagramDescription = diagramService.getDDiagram().getDescription();
            Optional<AbstractToolDescription> optionalTool = diagramDescription.getAllTools().stream().filter(tool -> tool.getName().equals(executeNodeCreationToolAction.getIdentifier())).findFirst();
            Optional optionalModelOperation = optionalTool.flatMap(this::getFirstModelOperation);
            System.out.println("Executing the model operation " + optionalModelOperation.toString());
        }
    }

    private Optional<ModelOperation> getFirstModelOperation(AbstractToolDescription toolDescription) {
        Optional<ModelOperation> optionalModelOperation = Optional.empty();
        if (toolDescription instanceof NodeCreationDescription) {
            NodeCreationDescription nodeCreationDescription = (NodeCreationDescription)toolDescription;
            optionalModelOperation = Optional.ofNullable(nodeCreationDescription.getInitialOperation().getFirstModelOperations());
        } else if (toolDescription instanceof ContainerCreationDescription) {
            ContainerCreationDescription containerCreationDescription = (ContainerCreationDescription)toolDescription;
            optionalModelOperation = Optional.ofNullable(containerCreationDescription.getInitialOperation().getFirstModelOperations());
        }
        return optionalModelOperation;
    }
}

