/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.layout;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartment2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.layout.GenericLayoutProvider;
import org.eclipse.sirius.diagram.ui.internal.refresh.layout.SiriusCanonicalLayoutCommand;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;

public final class SiriusCanonicalLayoutHandler {
    private SiriusCanonicalLayoutHandler() {
    }

    public static void launchArrangeCommand(DiagramEditPart diagramEditPart) {
        Command layoutCommand;
        TransactionalEditingDomain editingDomain = diagramEditPart.getEditingDomain();
        Map<IGraphicalEditPart, List<IAdaptable>> createdViewsToLayoutMap = SiriusCanonicalLayoutHandler.getCreatedViewsToLayoutMap(diagramEditPart);
        Map<IGraphicalEditPart, List<IAdaptable>> createdViewsWithSpecialLayoutMap = SiriusCanonicalLayoutHandler.getCreatedViewsWithSpecialLayoutMap(diagramEditPart);
        LayoutProvider layoutProvider = LayoutService.getProvider((IGraphicalEditPart)diagramEditPart);
        boolean handleSpecificLayoutType = false;
        if (layoutProvider instanceof GenericLayoutProvider && ((GenericLayoutProvider)layoutProvider).shouldReverseLayoutsOrder((IGraphicalEditPart)diagramEditPart)) {
            LinkedHashMap<IGraphicalEditPart, List<IAdaptable>> createdViewsToLayoutMap_reverse = new LinkedHashMap<IGraphicalEditPart, List<IAdaptable>>();
            ArrayList<IGraphicalEditPart> keys = new ArrayList<IGraphicalEditPart>(createdViewsToLayoutMap.keySet());
            int i = keys.size() - 1;
            while (i >= 0) {
                createdViewsToLayoutMap_reverse.put(keys.get(i), createdViewsToLayoutMap.get(keys.get(i)));
                --i;
            }
            createdViewsToLayoutMap = createdViewsToLayoutMap_reverse;
            handleSpecificLayoutType = true;
        }
        if ((layoutCommand = SiriusCanonicalLayoutHandler.getLayoutCommand(createdViewsToLayoutMap, createdViewsWithSpecialLayoutMap, editingDomain, handleSpecificLayoutType)).canExecute()) {
            editingDomain.getCommandStack().execute(layoutCommand);
        }
    }

    private static Map<IGraphicalEditPart, List<IAdaptable>> getCreatedViewsToLayoutMap(DiagramEditPart diagramEditPart) {
        LinkedHashMap<IGraphicalEditPart, List<IAdaptable>> createdViewsToLayoutMap = new LinkedHashMap<IGraphicalEditPart, List<IAdaptable>>();
        Map<Diagram, Set<View>> createdViewsToLayout = SiriusLayoutDataManager.INSTANCE.getCreatedViewsToLayout();
        SiriusCanonicalLayoutHandler.getCreatedViewToLayoutMap(diagramEditPart, createdViewsToLayoutMap, createdViewsToLayout);
        return createdViewsToLayoutMap;
    }

    private static Map<IGraphicalEditPart, List<IAdaptable>> getCreatedViewsWithSpecialLayoutMap(DiagramEditPart diagramEditPart) {
        LinkedHashMap<IGraphicalEditPart, List<IAdaptable>> createdViewsToLayoutMap = new LinkedHashMap<IGraphicalEditPart, List<IAdaptable>>();
        Map<Diagram, Set<View>> createdViewsToLayout = SiriusLayoutDataManager.INSTANCE.getCreatedViewWithCenterLayout();
        SiriusCanonicalLayoutHandler.getCreatedViewToLayoutMap(diagramEditPart, createdViewsToLayoutMap, createdViewsToLayout);
        return createdViewsToLayoutMap;
    }

    private static void getCreatedViewToLayoutMap(DiagramEditPart diagramEditPart, Map<IGraphicalEditPart, List<IAdaptable>> createdViewsToLayoutMap, Map<Diagram, Set<View>> createdViewsToLayout) {
        Diagram diagramOfOpenedEditor;
        if (!createdViewsToLayout.isEmpty() && (diagramOfOpenedEditor = diagramEditPart.getDiagramView()) != null && createdViewsToLayout.containsKey(diagramOfOpenedEditor)) {
            if (diagramEditPart != null) {
                Map editPartRegistry = diagramEditPart.getViewer().getEditPartRegistry();
                List<IAdaptable> viewAdapters = SiriusCanonicalLayoutHandler.getAdapters(createdViewsToLayout.get(diagramOfOpenedEditor));
                Map<View, List<IAdaptable>> splitedViewAdapters = SiriusCanonicalLayoutHandler.splitViewAdaptersAccordingToParent(viewAdapters);
                for (Map.Entry<View, List<IAdaptable>> viewAdaptersWithSameParent : splitedViewAdapters.entrySet()) {
                    View parentView = viewAdaptersWithSameParent.getKey();
                    List<IAdaptable> childViewsAdapters = viewAdaptersWithSameParent.getValue();
                    IGraphicalEditPart parentEditPart = (IGraphicalEditPart)editPartRegistry.get(parentView);
                    if (parentEditPart == null) continue;
                    createdViewsToLayoutMap.put(parentEditPart, childViewsAdapters);
                }
            }
            createdViewsToLayout.remove(diagramOfOpenedEditor);
        }
    }

    private static Map<View, List<IAdaptable>> splitViewAdaptersAccordingToParent(List<IAdaptable> viewAdapters) {
        LinkedHashMap<View, List<IAdaptable>> splitedViewAdaptersAccordingToParent = new LinkedHashMap<View, List<IAdaptable>>();
        for (IAdaptable viewAdapter : viewAdapters) {
            View createdViewToLayout = (View)viewAdapter.getAdapter(View.class);
            EObject eContainer = createdViewToLayout.eContainer();
            if (!(eContainer instanceof View)) continue;
            View parentView = (View)eContainer;
            ArrayList<IAdaptable> viewAdaptersWithSameParent = (ArrayList<IAdaptable>)splitedViewAdaptersAccordingToParent.get(parentView);
            if (viewAdaptersWithSameParent == null) {
                viewAdaptersWithSameParent = new ArrayList<IAdaptable>();
                splitedViewAdaptersAccordingToParent.put(parentView, viewAdaptersWithSameParent);
            }
            viewAdaptersWithSameParent.add(viewAdapter);
        }
        return splitedViewAdaptersAccordingToParent;
    }

    private static List<IAdaptable> getAdapters(Set<View> createdViewsToLayout) {
        ArrayList<IAdaptable> viewAdapters = new ArrayList<IAdaptable>();
        for (View createdViewToLayout : createdViewsToLayout) {
            viewAdapters.add((IAdaptable)new EObjectAdapter((EObject)createdViewToLayout));
        }
        return viewAdapters;
    }

    private static Command getLayoutCommand(Map<IGraphicalEditPart, List<IAdaptable>> createdViewsToLayoutMap, Map<IGraphicalEditPart, List<IAdaptable>> createdViewsWithSpecialLayoutMap, TransactionalEditingDomain editingDomain, boolean useSpecificLayoutType) {
        SiriusCanonicalLayoutCommand viewpointLayoutCanonicalSynchronizerCommand;
        List childViewsAdapters;
        IGraphicalEditPart parentEditPart;
        CompoundCommand compoundCommand = new CompoundCommand();
        Predicate<Map.Entry<IGraphicalEditPart, List<IAdaptable>>> typeOfElementToLayout = new Predicate<Map.Entry<IGraphicalEditPart, List<IAdaptable>>>(){

            public boolean apply(Map.Entry<IGraphicalEditPart, List<IAdaptable>> input) {
                return input.getKey() instanceof DDiagramEditPart || input.getKey() instanceof DNodeContainerViewNodeContainerCompartmentEditPart || input.getKey() instanceof DNodeContainerViewNodeContainerCompartment2EditPart && !(input.getKey().getParent().getParent() instanceof DNodeContainerViewNodeContainerCompartment2EditPart);
            }
        };
        for (Map.Entry entry : Iterables.filter(createdViewsToLayoutMap.entrySet(), (Predicate)typeOfElementToLayout)) {
            parentEditPart = (IGraphicalEditPart)entry.getKey();
            childViewsAdapters = (List)entry.getValue();
            viewpointLayoutCanonicalSynchronizerCommand = new SiriusCanonicalLayoutCommand(editingDomain, parentEditPart, childViewsAdapters, null, useSpecificLayoutType);
            compoundCommand.append((Command)viewpointLayoutCanonicalSynchronizerCommand);
        }
        for (Map.Entry entry : Iterables.filter(createdViewsWithSpecialLayoutMap.entrySet(), (Predicate)typeOfElementToLayout)) {
            parentEditPart = (IGraphicalEditPart)entry.getKey();
            childViewsAdapters = (List)entry.getValue();
            viewpointLayoutCanonicalSynchronizerCommand = new SiriusCanonicalLayoutCommand(editingDomain, parentEditPart, null, childViewsAdapters, useSpecificLayoutType);
            compoundCommand.append((Command)viewpointLayoutCanonicalSynchronizerCommand);
        }
        return compoundCommand;
    }
}

