/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.internal.metamodel.query.DTreeItemInternalQuery;
import org.eclipse.sirius.tree.description.TreeItemDeletionTool;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;

public class DeleteTreeItemsAction
extends Action {
    private final ITreeCommandFactory treeCommandFactory;
    private final TransactionalEditingDomain editingDomain;
    private final Collection<DTreeItem> items = new ArrayList<DTreeItem>();

    public DeleteTreeItemsAction(TransactionalEditingDomain editingDomain, ITreeCommandFactory treeCommandFactory) {
        super(Messages.DeleteTreeItemsAction_deleteTreeItem, DTreeViewerManager.getImageRegistry().getDescriptor("tree/delete"));
        this.editingDomain = editingDomain;
        this.treeCommandFactory = treeCommandFactory;
    }

    public void run() {
        super.run();
        CompoundCommand cc = new CompoundCommand(this.getText());
        for (DTreeItem item : this.items) {
            cc.append(this.treeCommandFactory.buildDeleteTreeElement((DTreeElement)item));
        }
        this.getEditingDomain().getCommandStack().execute((Command)cc);
        this.items.clear();
    }

    private TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    private TreeItemDeletionTool getDeleteTool(DTreeItem treeItem) {
        TreeItemMapping actualMapping;
        TreeItemDeletionTool tool = null;
        if (treeItem != null && (actualMapping = treeItem.getActualMapping()) != null) {
            tool = actualMapping.getDelete();
        }
        return tool;
    }

    public void setItems(Collection<DTreeItem> itemsToDelete) {
        this.items.clear();
        if (itemsToDelete != null) {
            this.items.addAll(itemsToDelete);
        }
        if (this.items.size() == 1) {
            this.setText(Messages.DeleteTreeItemsAction_deleteTreeItem);
            this.setToolTipText(Messages.DeleteTreeItemsAction_deleteTargetSemanticElement);
            TreeItemDeletionTool deleteTool = this.getDeleteTool(this.items.iterator().next());
            if (deleteTool != null) {
                this.setText(new IdentifiedElementQuery((IdentifiedElement)deleteTool).getLabel());
                this.setToolTipText(MessageTranslator.INSTANCE.getMessage((EObject)deleteTool, deleteTool.getDocumentation()));
            }
        } else if (this.items.size() > 1) {
            this.setText(Messages.DeleteTreeItemsAction_deleteTreeItems);
            this.setToolTipText(Messages.DeleteTreeItemsAction_deleteTargetSemanticElements);
        }
    }

    public boolean canExecute() {
        boolean canExecute = !this.items.isEmpty();
        for (DTreeItem itemToDelete : this.items) {
            boolean bl = canExecute = canExecute && new DTreeItemInternalQuery(itemToDelete).canBeDeleted();
            if (!canExecute) break;
        }
        return canExecute;
    }
}

