/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.business.internal.dialect;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.internal.metamodel.TreeToolVariables;
import org.eclipse.sirius.tree.description.DescriptionFactory;
import org.eclipse.sirius.tree.description.TreeCreationDescription;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeNavigationDescription;
import org.eclipse.sirius.tree.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.tree.provider.TreeItemProviderAdapterFactory;
import org.eclipse.sirius.tree.ui.business.internal.refresh.TreeRefresherHelper;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIServices;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.business.api.dialect.ExportResult;
import org.eclipse.sirius.ui.business.api.dialect.HierarchyLabelProvider;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TreeDialectUIServices
implements DialectUIServices {
    public boolean canHandle(DRepresentation representation) {
        return representation instanceof DTree;
    }

    public boolean canHandle(DRepresentationDescriptor representationDescriptor) {
        return representationDescriptor.getDescription() instanceof TreeDescription;
    }

    public boolean canHandle(RepresentationDescription representation) {
        return representation instanceof TreeDescription;
    }

    public boolean canHandle(RepresentationExtensionDescription description) {
        return false;
    }

    public boolean canHandleEditor(IEditorPart editorPart) {
        return editorPart instanceof DTreeEditor;
    }

    public IEditorPart openEditor(Session session, DRepresentation dRepresentation, IProgressMonitor monitor) {
        IEditorPart editorPart = null;
        try {
            monitor.beginTask(Messages.TreeDialectUIServices_treeOpening, 10);
            if (dRepresentation instanceof DTree) {
                DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.OPEN_TREE_KEY);
                URI uri = EcoreUtil.getURI((EObject)dRepresentation);
                DRepresentationQuery query = new DRepresentationQuery(dRepresentation);
                DRepresentationDescriptor representationDescriptor = query.getRepresentationDescriptor();
                URI repDescURI = Optional.ofNullable(representationDescriptor).map(repDesc -> EcoreUtil.getURI((EObject)repDesc)).orElse(null);
                SessionEditorInput editorInput = new SessionEditorInput(uri, repDescURI, this.getEditorName(dRepresentation), session);
                monitor.worked(2);
                monitor.subTask(String.valueOf(Messages.TreeDialectUIServices_treeOpening) + " : " + representationDescriptor.getName());
                RunnableWithResult.Impl<IEditorPart> runnable = new RunnableWithResult.Impl<IEditorPart>((IEditorInput)editorInput){
                    private final /* synthetic */ IEditorInput val$editorInput;
                    {
                        this.val$editorInput = iEditorInput;
                    }

                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            this.setResult(page.openEditor(this.val$editorInput, "org.eclipse.sirius.tree.ui.EditorID"));
                        }
                        catch (PartInitException e) {
                            TreeUIPlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.tree.ui", Messages.TreeDialectUIServices_errorOpeningEditor, (Throwable)e));
                        }
                    }
                };
                EclipseUIUtil.displaySyncExec((Runnable)runnable);
                monitor.worked(8);
                IEditorPart result = (IEditorPart)runnable.getResult();
                if (this.canHandleEditor(result)) {
                    DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.OPEN_TREE_KEY);
                    editorPart = result;
                }
            }
        }
        finally {
            monitor.done();
        }
        return editorPart;
    }

    public String getEditorName(DRepresentation representation) {
        String editorName = representation.getName();
        if (StringUtil.isEmpty((String)editorName)) {
            editorName = Messages.TreeDialectUIServices_newTree;
        }
        return editorName;
    }

    public boolean closeEditor(IEditorPart editorPart, boolean save) {
        boolean result = false;
        if (this.canHandleEditor(editorPart)) {
            try {
                ((DTreeEditor)editorPart).close(save);
            }
            catch (NullPointerException e) {
                TreeUIPlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.tree.ui", Messages.TreeDialectUIServices_errorOpeningEditor, (Throwable)e));
            }
            result = true;
        }
        return result;
    }

    public boolean isRepresentationManagedByEditor(DRepresentation representation, IEditorPart editorPart) {
        boolean isRepresentationManagedByEditor = false;
        if (this.canHandleEditor(editorPart)) {
            DTreeEditor dTreeEditor = (DTreeEditor)editorPart;
            isRepresentationManagedByEditor = dTreeEditor.getRepresentation() != null && dTreeEditor.getRepresentation().equals(representation);
        }
        return isRepresentationManagedByEditor;
    }

    public boolean isRepresentationDescriptionManagedByEditor(RepresentationDescription representationDescription, IEditorPart editorPart) {
        if (this.canHandleEditor(editorPart)) {
            DTreeEditor dtreeEditor = (DTreeEditor)editorPart;
            return EcoreUtil.equals((EObject)dtreeEditor.getTreeModel().getDescription(), (EObject)representationDescription);
        }
        return false;
    }

    public AdapterFactory createAdapterFactory() {
        ComposedAdapterFactory factory = new ComposedAdapterFactory();
        factory.addAdapterFactory((AdapterFactory)new DescriptionItemProviderAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new TreeItemProviderAdapterFactory());
        return factory;
    }

    public boolean canExport(ExportFormat format) {
        return false;
    }

    public ExportResult exportWithResult(DRepresentation representation, Session session, IPath path, ExportFormat format, IProgressMonitor monitor) {
        return new ExportResult(representation, Collections.emptySet());
    }

    public Collection<CommandParameter> provideNewChildDescriptors() {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        TreeDescription treeDescription = DescriptionFactory.eINSTANCE.createTreeDescription();
        newChilds.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.VIEWPOINT__OWNED_REPRESENTATIONS, (Object)treeDescription));
        return newChilds;
    }

    public Collection<CommandParameter> provideRepresentationCreationToolDescriptors(Object feature) {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        TreeCreationDescription treeCreationDescription = DescriptionFactory.eINSTANCE.createTreeCreationDescription();
        new TreeToolVariables().doSwitch((EObject)treeCreationDescription);
        newChilds.add(new CommandParameter(null, feature, (Object)treeCreationDescription));
        return newChilds;
    }

    public Collection<CommandParameter> provideRepresentationNavigationToolDescriptors(Object feature) {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        TreeNavigationDescription treeNavigationDescription = DescriptionFactory.eINSTANCE.createTreeNavigationDescription();
        new TreeToolVariables().doSwitch((EObject)treeNavigationDescription);
        newChilds.add(new CommandParameter(null, feature, (Object)treeNavigationDescription));
        return newChilds;
    }

    public Collection<CommandParameter> provideTools(EObject object) {
        return Collections.emptyList();
    }

    public Collection<CommandParameter> provideAdditionalMappings(EObject object) {
        return Collections.emptyList();
    }

    public ILabelProvider getHierarchyLabelProvider(ILabelProvider currentLabelProvider) {
        return new HierarchyLabelProvider(currentLabelProvider);
    }

    public void setSelection(DialectEditor dialectEditor, List<DRepresentationElement> selection) {
        if (dialectEditor instanceof DTreeEditor) {
            Viewer viewer = ((DTreeEditor)dialectEditor).getViewer();
            Iterable treeElements = Iterables.filter(selection, DTreeItem.class);
            if (viewer != null) {
                viewer.setSelection((ISelection)new StructuredSelection((List)Lists.newArrayList((Iterable)treeElements)));
            }
        }
    }

    public void selectAndReveal(DialectEditor dialectEditor, List<DRepresentationElement> selection) {
        this.setSelection(dialectEditor, selection);
    }

    public Collection<DSemanticDecorator> getSelection(DialectEditor editor) {
        LinkedHashSet<DSemanticDecorator> selection = new LinkedHashSet<DSemanticDecorator>();
        if (editor instanceof DTreeEditor) {
            ISelection sel;
            DTreeEditor dEditor = (DTreeEditor)editor;
            if (editor.getSite() != null && editor.getSite().getSelectionProvider() != null && (sel = dEditor.getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
                Iterables.addAll(selection, (Iterable)Iterables.filter((Iterable)((IStructuredSelection)sel).toList(), DSemanticDecorator.class));
            }
        }
        return selection;
    }

    public String completeToolTipText(String toolTipText, EObject eObject, EStructuralFeature feature) {
        return toolTipText;
    }

    @Deprecated
    public String completeToolTipText(String toolTipText, EObject eObject) {
        return toolTipText;
    }

    public void refreshEditor(DialectEditor dialectEditor, IProgressMonitor monitor) {
        if (dialectEditor instanceof DTreeEditor) {
            DTreeEditor treeEditor = (DTreeEditor)dialectEditor;
            TreeRefresherHelper.refreshEditor(treeEditor, (IStructuredSelection)new StructuredSelection(), monitor);
        }
    }
}

