/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation;

import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.WorkspaceOptionalUtils;

public final class FileCreationHelper {
    private static final String DESCRIPTION_ARG = "description";

    private FileCreationHelper() {
    }

    public static Optional<IFile> getFile(DataFetchingEnvironment environment) {
        Map description = (Map)environment.getArgument(DESCRIPTION_ARG);
        String name = (String)description.get("name");
        Optional<IContainer> optionalContainer = FileCreationHelper.getContainer(environment);
        return optionalContainer.map(iContainer -> iContainer.getFile((IPath)new Path(name)));
    }

    private static Optional<IContainer> getContainer(DataFetchingEnvironment environment) {
        Optional<IProject> optionalProject = WorkspaceOptionalUtils.projectFromName(environment.getArgument("projectName"));
        Optional<String> optionalContainerPath = Optional.of((String)environment.getArgument("containerPath"));
        return optionalContainerPath.flatMap(containerPath -> optionalProject.map(iProject -> iProject.findMember(containerPath)).filter(IContainer.class::isInstance).map(IContainer.class::cast));
    }
}

