/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.provider;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutExtender;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.GridView;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.SimpleViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrderingHint;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.ExtendableLayoutProvider;

public class GridLayoutProvider
extends DefaultLayoutProvider
implements ExtendableLayoutProvider {
    public static final int SAME_DIMENSION = 1;
    public static final int DIMENSION_BY_LINE_OR_COLUMN = 2;
    public static final int FREE_DIMENSION = 3;
    private Map<Point, Point> locationsCache = new HashMap<Point, Point>();
    private int columnSizeMode = 1;
    private int lineSizeMode = 1;
    private Insets padding = new Insets(30, 30, 30, 30);
    private Map<Integer, Integer> maxWidths = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> maxHeights = new HashMap<Integer, Integer>();
    private final LayoutExtender extender = new LayoutExtender(this);

    public Insets getPadding() {
        return this.padding;
    }

    public int getColumnSizeMode() {
        return this.columnSizeMode;
    }

    public void setColumnSizeMode(int columnSizeMode) {
        if (columnSizeMode < 1 || columnSizeMode > 3) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.GridLayoutProvider_unknownMode, columnSizeMode));
        }
        this.columnSizeMode = columnSizeMode;
    }

    public int getLineSizeMode() {
        return this.lineSizeMode;
    }

    public void setLineSizeMode(int lineSizeMode) {
        if (lineSizeMode < 1 || lineSizeMode > 3) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.GridLayoutProvider_unknownMode, lineSizeMode));
        }
        this.lineSizeMode = lineSizeMode;
    }

    @Override
    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        this.extender.startLayouting();
        this.maxHeights.clear();
        this.maxWidths.clear();
        this.locationsCache.clear();
        Iterator iterEditParts = selectedObjects.iterator();
        ArrayList<View> views = new ArrayList<View>(selectedObjects.size());
        HashMap<View, IGraphicalEditPart> viewsToEditPartMap = new HashMap<View, IGraphicalEditPart>();
        while (iterEditParts.hasNext()) {
            Object next = iterEditParts.next();
            if (next instanceof ShapeEditPart && !(next instanceof IBorderItemEditPart)) {
                ShapeEditPart shapeEditPart = (ShapeEditPart)next;
                View view = shapeEditPart.getNotationView();
                viewsToEditPartMap.put(view, (IGraphicalEditPart)shapeEditPart);
                views.add(view);
                continue;
            }
            iterEditParts.remove();
        }
        ViewOrdering viewOrdering = ViewOrderingHint.getInstance().consumeViewOrdering(this.getContainerEditPart(selectedObjects).getNotationView());
        if (viewOrdering == null) {
            viewOrdering = new SimpleViewOrdering();
        }
        viewOrdering.setViews(views);
        GridView gridView = viewOrdering.getSortedViewsAsGrid();
        Command command = this.buildGrid(gridView, viewsToEditPartMap);
        Command layoutContainer = this.getLayoutContainerCommand(this.getContainerEditPart(selectedObjects), gridView);
        this.maxHeights.clear();
        this.maxWidths.clear();
        this.locationsCache.clear();
        CompoundCommand cc = new CompoundCommand();
        cc.add(command);
        if (layoutContainer != null && layoutContainer.canExecute()) {
            cc.add(layoutContainer);
        }
        return cc;
    }

    private Command getLayoutContainerCommand(IGraphicalEditPart containerEditPart, GridView gridView) {
        Dimension containerMinDimension = this.getLayoutDimensions(gridView);
        Dimension expand = new Dimension(0, 0);
        Dimension containerBounds = this.getBounds(containerEditPart).getSize();
        if (containerBounds.width < containerMinDimension.width) {
            expand.width = containerMinDimension.width - containerBounds.width;
        }
        if (containerBounds.height < containerMinDimension.height) {
            expand.height = containerMinDimension.height - containerBounds.height;
        }
        if (expand.width > 0 || expand.height > 0) {
            Object existingRequest = this.viewsToChangeBoundsRequest.get(containerEditPart.getNotationView());
            if (existingRequest == null) {
                ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"resize");
                cbr.setResizeDirection(20);
                cbr.setSizeDelta(expand);
                Command command = this.buildCommandWrapper((Request)cbr, (EditPart)containerEditPart);
                return command;
            }
            if (existingRequest instanceof ChangeBoundsRequest) {
                ChangeBoundsRequest cbr = (ChangeBoundsRequest)existingRequest;
                cbr.setResizeDirection(20);
                cbr.setSizeDelta(expand);
            }
        }
        return null;
    }

    protected Command buildGrid(GridView gridView, Map<View, IGraphicalEditPart> viewsToEditPart) {
        GridView.Column currentColumn;
        Iterator<GridView.Column> iterColumns;
        CompoundCommand cc = new CompoundCommand();
        if (this.getColumnSizeMode() != 3 || this.getLineSizeMode() != 3) {
            iterColumns = gridView.iteratorColumns();
            while (iterColumns.hasNext()) {
                currentColumn = iterColumns.next();
                Integer columnIndex = currentColumn.getIndex();
                this.maxWidths.put(columnIndex, -1);
                int i = 0;
                while (i < currentColumn.getViewsCount()) {
                    Integer lineIndex = i;
                    View view = currentColumn.getViewAt(i);
                    Dimension size = new Dimension(0, 0);
                    if (view != null) {
                        IGraphicalEditPart editPart = viewsToEditPart.get(view);
                        size = this.getBounds(editPart).getSize();
                    }
                    if (this.maxHeights.get(lineIndex) == null) {
                        this.maxHeights.put(lineIndex, -1);
                    }
                    if (size.width > this.maxWidths.get(columnIndex)) {
                        this.maxWidths.put(columnIndex, size.width);
                    }
                    if (size.height > this.maxHeights.get(lineIndex)) {
                        this.maxHeights.put(lineIndex, size.height);
                    }
                    ++i;
                }
            }
        }
        iterColumns = gridView.iteratorColumns();
        while (iterColumns.hasNext()) {
            currentColumn = iterColumns.next();
            int i = 0;
            while (i < currentColumn.getViewsCount()) {
                Point newLocation;
                IGraphicalEditPart editPart;
                Command command;
                Point caseLocation = this.getLocation(currentColumn.getIndex(), i, gridView, viewsToEditPart);
                if (currentColumn.getViewAt(i) != null && (command = this.createChangeBoundsCommand(editPart = viewsToEditPart.get(currentColumn.getViewAt(i)), newLocation = new Point(caseLocation.x + this.getPadding().left, caseLocation.y + this.getPadding().top))) != null && command.canExecute()) {
                    cc.add(command);
                }
                ++i;
            }
        }
        return cc;
    }

    protected Command createChangeBoundsCommand(IGraphicalEditPart editPart, Point newPosition) {
        Command result = null;
        Request existingRequest = this.findRequest(editPart, (Object)"move");
        ChangeBoundsRequest request = null;
        double scale = 1.0;
        if (editPart.getRoot() instanceof DiagramRootEditPart) {
            ZoomManager zoomManager = ((DiagramRootEditPart)editPart.getRoot()).getZoomManager();
            scale = zoomManager.getZoom();
        }
        if (existingRequest instanceof ChangeBoundsRequest) {
            request = (ChangeBoundsRequest)existingRequest;
        } else if (existingRequest == null) {
            request = new ChangeBoundsRequest();
            request.setEditParts((EditPart)editPart);
            result = this.buildCommandWrapper((Request)request, (EditPart)editPart);
        }
        if (newPosition != null) {
            Rectangle intrinsicBounds = editPart.getFigure().getBounds();
            Dimension delta = newPosition.getDifference(intrinsicBounds.getLocation());
            delta.width = (int)((double)delta.width * scale);
            delta.height = (int)((double)delta.height * scale);
            if ((delta.width != 0 || delta.height != 0) && request != null) {
                request.setMoveDelta(new Point(delta.width, delta.height));
                request.setLocation(newPosition);
                request.setType((Object)"move");
                result = this.buildCommandWrapper((Request)request, (EditPart)editPart);
                this.extender.getUpdatedBounds().put(editPart, new Rectangle(newPosition, intrinsicBounds.getSize()));
            } else {
                return null;
            }
        }
        return result;
    }

    private Dimension getDiagramMaxDimension() {
        int maxHeight = -1;
        for (Integer currentValue : this.maxHeights.values()) {
            if (currentValue <= maxHeight) continue;
            maxHeight = currentValue;
        }
        for (Integer currentValue : this.maxWidths.values()) {
            if (currentValue <= -1) continue;
            maxHeight = currentValue;
        }
        return new Dimension(-1, maxHeight);
    }

    private Dimension getLayoutDimensions(GridView gridView) {
        Dimension result = new Dimension();
        switch (this.getLineSizeMode()) {
            case 2: 
            case 3: {
                for (Integer currentValue : this.maxHeights.values()) {
                    result.height += currentValue.intValue();
                    result.height += this.getPadding().top;
                    result.height += this.getPadding().bottom;
                }
                break;
            }
            case 1: {
                result.height = this.getDiagramMaxDimension().height + (this.getPadding().top + this.getPadding().bottom) * gridView.getLinesCount();
                break;
            }
        }
        switch (this.getColumnSizeMode()) {
            case 2: 
            case 3: {
                for (Integer currentValue : this.maxWidths.values()) {
                    result.width += currentValue.intValue();
                    result.width += this.getPadding().left;
                    result.width += this.getPadding().top;
                }
                break;
            }
            case 1: {
                result.width = this.getDiagramMaxDimension().width + (this.getPadding().left + this.getPadding().right) * gridView.getColumnsCount();
                break;
            }
        }
        return result;
    }

    protected IGraphicalEditPart getContainerEditPart(List<?> selectedObjects) {
        if (selectedObjects != null && !selectedObjects.isEmpty()) {
            return (IGraphicalEditPart)((EditPart)selectedObjects.iterator().next()).getParent();
        }
        return null;
    }

    public Point getLocation(int x, int y, GridView gridView, Map<View, IGraphicalEditPart> viewsToEditParts) {
        Point point = new Point(x, y);
        Point cachedLocation = this.locationsCache.get(point);
        if (cachedLocation != null) {
            return cachedLocation;
        }
        Point location = new Point();
        if (x == 0 && y == 0) {
            location.x = 0;
            location.y = 0;
        } else {
            Dimension size;
            if (x == 0) {
                location.x = 0;
            } else {
                Point left = this.getLocation(x - 1, y, gridView, viewsToEditParts);
                View leftView = gridView.getViewAt(x - 1, y);
                size = new Dimension(0, 0);
                if (leftView != null) {
                    IGraphicalEditPart leftEditPart = viewsToEditParts.get(leftView);
                    size = this.getBounds(leftEditPart).getSize();
                }
                switch (this.getColumnSizeMode()) {
                    case 3: {
                        location.x = left.x + size.width + this.getPadding().left + this.getPadding().right;
                        break;
                    }
                    case 1: {
                        location.x = left.x + this.getDiagramMaxDimension().width + this.getPadding().left + this.getPadding().right;
                        break;
                    }
                    case 2: {
                        location.x = left.x + this.maxWidths.get(x - 1) + this.getPadding().right + this.getPadding().left;
                        break;
                    }
                }
            }
            if (y == 0) {
                location.y = 0;
            } else {
                Point top = this.getLocation(x, y - 1, gridView, viewsToEditParts);
                View topView = gridView.getViewAt(x, y - 1);
                size = new Dimension(0, 0);
                if (topView != null) {
                    IGraphicalEditPart topEditPart = viewsToEditParts.get(topView);
                    size = this.getBounds(topEditPart).getSize();
                }
                switch (this.getLineSizeMode()) {
                    case 3: {
                        location.y = top.y + size.height + this.getPadding().top + this.getPadding().bottom;
                        break;
                    }
                    case 1: {
                        location.y = top.y + this.getDiagramMaxDimension().height + this.getPadding().top + this.getPadding().bottom;
                        break;
                    }
                    case 2: {
                        location.y = top.y + this.maxHeights.get(y - 1) + this.getPadding().top + this.getPadding().bottom;
                        break;
                    }
                }
            }
        }
        this.locationsCache.put(point, location);
        return location;
    }

    @Override
    public LayoutExtender getExtender() {
        return this.extender;
    }

    @Override
    public boolean handleConnectableListItems() {
        return false;
    }

    @Override
    public Rectangle provideNodeMetrics(Node node) {
        return null;
    }
}

