/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.eclipse.sirius.diagram.BeginLabelStyle;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.business.api.query.NodeStyleQuery;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;

public class ColorStyleQuery {
    private final Style style;

    public ColorStyleQuery(Style style) {
        this.style = (Style)Preconditions.checkNotNull((Object)style);
    }

    public Optional<RGBValues> getLabelColor() {
        RGBValues rgbValues = null;
        if (this.style instanceof BasicLabelStyle) {
            rgbValues = ((BasicLabelStyle)this.style).getLabelColor();
        } else if (this.style instanceof EdgeStyle) {
            EdgeStyle edgeStyle = (EdgeStyle)this.style;
            BeginLabelStyle labelStyle = edgeStyle.getBeginLabelStyle();
            if (labelStyle == null && (labelStyle = edgeStyle.getCenterLabelStyle()) == null) {
                labelStyle = edgeStyle.getEndLabelStyle();
            }
            if (labelStyle != null) {
                rgbValues = labelStyle.getLabelColor();
            }
        }
        return Optional.ofNullable(rgbValues);
    }

    public Optional<RGBValues> getLineColor() {
        RGBValues rgbValues = null;
        if (this.style instanceof EdgeStyle) {
            rgbValues = ((EdgeStyle)this.style).getStrokeColor();
        } else if (this.style instanceof BorderedStyle) {
            rgbValues = ((BorderedStyle)this.style).getBorderColor();
        }
        return Optional.ofNullable(rgbValues);
    }

    public Optional<RGBValues> getFillColor() {
        RGBValues rgbValues = null;
        if (this.style instanceof NodeStyle) {
            rgbValues = (RGBValues)new NodeStyleQuery((NodeStyle)this.style).getBackgroundColor().get();
        } else if (this.style instanceof FlatContainerStyle) {
            rgbValues = ((FlatContainerStyle)this.style).getBackgroundColor();
        } else if (this.style instanceof ShapeContainerStyle) {
            rgbValues = ((ShapeContainerStyle)this.style).getBackgroundColor();
        }
        return Optional.ofNullable(rgbValues);
    }
}

