/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.apidef.OptApiFunction;
import org.eclipse.scout.sdk.core.s.util.ITier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.util.ApiHelper;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public final class S2eTier
implements Predicate<IJavaElement> {
    private final ITier<?> m_tier;

    private S2eTier(ITier<?> t) {
        this.m_tier = t;
    }

    public ITier<?> unwrap() {
        return this.m_tier;
    }

    public Optional<IJavaProject> convert(ITier<?> to, IJavaProject origin) {
        if (!JdtUtils.exists((IJavaElement)origin) || to == null) {
            return Optional.empty();
        }
        String originJavaProjectName = origin.getElementName();
        IJavaProject project = origin.getJavaModel().getJavaProject(this.unwrap().convert(to, originJavaProjectName));
        if (!JdtUtils.exists((IJavaElement)project)) {
            return Optional.empty();
        }
        Optional<ITier> projectTier = S2eTier.of((IJavaElement)project).map(S2eTier::unwrap);
        if (projectTier.isEmpty()) {
            return Optional.empty();
        }
        if (to == projectTier.orElseThrow()) {
            return Optional.of(project);
        }
        return Optional.empty();
    }

    public Optional<IPackageFragment> convert(ITier<?> to, IPackageFragment origin) {
        if (!JdtUtils.exists((IJavaElement)origin) || to == null) {
            return Optional.empty();
        }
        Optional<IPackageFragmentRoot> targetSrcFolder = this.convert(to, JdtUtils.getSourceFolder((IJavaElement)origin));
        if (targetSrcFolder.isEmpty()) {
            return Optional.empty();
        }
        String name = this.unwrap().convert(to, origin.getElementName());
        IPackageFragment packageFragment = targetSrcFolder.orElseThrow().getPackageFragment(name);
        if (JdtUtils.exists((IJavaElement)packageFragment)) {
            return Optional.of(packageFragment);
        }
        return Optional.empty();
    }

    public Optional<IPackageFragmentRoot> convert(ITier<?> to, IPackageFragmentRoot origin) {
        IJavaElement element;
        if (!JdtUtils.exists((IJavaElement)origin) || to == null) {
            return Optional.empty();
        }
        Optional<IJavaProject> targetProject = this.convert(to, origin.getJavaProject());
        if (targetProject.isEmpty()) {
            return Optional.empty();
        }
        String projectRelResourcePath = origin.getPath().removeFirstSegments(1).toString();
        IFolder folder = targetProject.orElseThrow().getProject().getFolder(projectRelResourcePath);
        if (folder != null && folder.exists() && JdtUtils.exists(element = JavaCore.create((IFolder)folder)) && element.getElementType() == 3) {
            return Optional.of((IPackageFragmentRoot)element);
        }
        return S2eUtils.primarySourceFolder(targetProject.orElseThrow());
    }

    public static S2eTier wrap(ITier<?> t) {
        return new S2eTier((ITier)Ensure.notNull(t));
    }

    public static Optional<S2eTier> of(final IJavaElement t) {
        if (!JdtUtils.exists(t)) {
            return Optional.empty();
        }
        return ITier.of(fqn -> JdtUtils.exists((IJavaElement)S2eTier.lookupJdtType(t, fqn)), (OptApiFunction)new OptApiFunction(){

            public <T extends IApiSpecification> Optional<T> apply(Class<T> api) {
                return ApiHelper.apiFor(t.getJavaProject(), api);
            }
        }).map(S2eTier::wrap);
    }

    static IType lookupJdtType(IJavaElement t, String fqn) {
        try {
            return t.getJavaProject().findType(fqn);
        }
        catch (JavaModelException ex) {
            throw new SdkException((Throwable)ex);
        }
    }

    @Override
    public boolean test(IJavaElement t) {
        Optional<S2eTier> tier = S2eTier.of(t);
        return tier.filter(s2eTier -> this.unwrap().isIncludedIn(s2eTier.unwrap())).isPresent();
    }

    public int hashCode() {
        return this.m_tier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        S2eTier other = (S2eTier)obj;
        return this.m_tier == other.m_tier;
    }

    public String toString() {
        return this.m_tier.toString();
    }
}

