/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.wellform;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.operation.wellform.WellformScoutTypeOperation;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class WellformAllOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    @Override
    public void accept(EclipseEnvironment env, EclipseProgress p) {
        String[] roots;
        int numTicks = 100;
        int searchStepTicks = 1;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)p.monitor(), (String)"Wellform Scout classes...", (int)numTicks);
        progress.subTask("Searching for classes...");
        HashSet<IType> types = new HashSet<IType>();
        String[] stringArray = roots = new String[]{"org.eclipse.scout.rt.shared.services.common.code.ICodeType", "org.eclipse.scout.rt.client.ui.desktop.IDesktop", "org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension", "org.eclipse.scout.rt.client.ui.form.IForm", "org.eclipse.scout.rt.client.ui.wizard.IWizard", "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage", "org.eclipse.scout.rt.client.ui.desktop.outline.IOutline"};
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            Set<IType> rootTypes = JdtUtils.resolveJdtTypes(root);
            for (IType t : rootTypes) {
                try {
                    ITypeHierarchy codeTypeHierarchy = t.newTypeHierarchy(null);
                    IType[] iTypeArray = codeTypeHierarchy.getAllClasses();
                    int n3 = iTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType candidate = iTypeArray[n4];
                        if (JdtUtils.exists((IJavaElement)candidate) && !candidate.isInterface() && !candidate.isBinary() && !candidate.isAnonymous() && candidate.getDeclaringType() == null) {
                            types.add(candidate);
                        }
                        if (progress.isCanceled()) {
                            return;
                        }
                        ++n4;
                    }
                }
                catch (JavaModelException e) {
                    SdkLog.warning((CharSequence)"Unable to collect classes to wellform for base type '{}'. These classes will be skipped.", (Object[])new Object[]{t.getFullyQualifiedName(), e});
                }
            }
            progress.worked(searchStepTicks);
            ++n2;
        }
        progress.subTask("Wellform classes...");
        new WellformScoutTypeOperation(types, true).accept(env, p.newChild(numTicks - searchStepTicks * roots.length));
    }

    public String toString() {
        return "Wellform all Scout classes";
    }
}

