/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.shortcut;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.RunnableContextHelper;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.TypeInspector;

class ApplicationSearchEngine {
    private static final int SCOPE_CONSTRAINTS = 11;
    private final RunnableContextHelper runnableContextHelper;
    private final ApplicationCollector collector;
    private IJavaSearchScope searchScope;

    ApplicationSearchEngine(IRunnableContext runnableContext) {
        this.runnableContextHelper = new RunnableContextHelper(runnableContext);
        this.collector = new ApplicationCollector();
    }

    IType[] search(IJavaElement[] javaElements) throws CoreException, InterruptedException {
        this.searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)11);
        this.collector.clear();
        RunnableContextHelper.IContextRunnable contextRunnable = new RunnableContextHelper.IContextRunnable(){

            public void run(IProgressMonitor monitor) throws Exception {
                ApplicationSearchEngine.this.search(monitor);
            }
        };
        this.runnableContextHelper.runInContext(contextRunnable);
        return this.collector.getResult();
    }

    private void search(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Searching for entry points or application configurations...", 100);
        try {
            int matchRule = 8;
            SearchParticipant[] participants = ApplicationSearchEngine.getSearchParticipants();
            SubProgressMonitor searchMonitor = new SubProgressMonitor(monitor, 100);
            SearchEngine searchEngine = new SearchEngine();
            SearchPattern pattern1 = SearchPattern.createPattern((String)"createUI() int", (int)1, (int)0, (int)matchRule);
            SearchPattern pattern2 = SearchPattern.createPattern((String)"createContents( Composite ) void", (int)1, (int)0, (int)matchRule);
            SearchPattern pattern3 = SearchPattern.createPattern((String)"configure( Application ) void", (int)1, (int)0, (int)matchRule);
            SearchPattern pattern1or2 = SearchPattern.createOrPattern((SearchPattern)pattern1, (SearchPattern)pattern2);
            SearchPattern pattern = SearchPattern.createOrPattern((SearchPattern)pattern3, (SearchPattern)pattern1or2);
            searchEngine.search(pattern, participants, this.searchScope, (SearchRequestor)this.collector, (IProgressMonitor)searchMonitor);
        }
        finally {
            monitor.done();
        }
    }

    private static SearchParticipant[] getSearchParticipants() {
        return new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    }

    private static class ApplicationCollector
    extends SearchRequestor {
        private final List<IType> collectedTypes = new LinkedList<IType>();

        void clear() {
            this.collectedTypes.clear();
        }

        IType[] getResult() {
            return this.collectedTypes.toArray(new IType[this.collectedTypes.size()]);
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            IMethod method;
            IType type;
            TypeInspector inspector;
            Object enclosingElement = match.getElement();
            if (enclosingElement instanceof IMethod && ((inspector = new TypeInspector(type = (method = (IMethod)enclosingElement).getDeclaringType())).isEntryPointType() || inspector.isApplicationConfigurationType())) {
                this.collectedTypes.add(type);
            }
        }
    }
}

