/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.jmx;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.jmx.AbstractHandlerMBean;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;

@ManagedObject(value="ContextHandler mbean wrapper")
public class ContextHandlerMBean
extends AbstractHandlerMBean {
    private ContextHandler _contextHandler;

    public ContextHandlerMBean(Object managedObject) {
        super(managedObject);
        this._contextHandler = (ContextHandler)managedObject;
    }

    @ManagedAttribute(value="Map of context attributes")
    public Map<String, Object> getContextAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String name : this._contextHandler.getContext().getAttributeNameSet()) {
            Object value = this._contextHandler.getContext().getAttribute(name);
            map.put(name, value);
        }
        return map;
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") Object value) {
        this._contextHandler.getContext().setAttribute(name, value);
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") String value) {
        this._contextHandler.getContext().setAttribute(name, value);
    }

    @ManagedOperation(value="Remove context attribute", impact="ACTION")
    public void removeContextAttribute(@Name(value="name", description="attribute name") String name) {
        this._contextHandler.getContext().removeAttribute(name);
    }
}

