/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.spy.dialogs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.pde.internal.runtime.spy.dialogs.GeometryUtil;
import org.eclipse.pde.internal.runtime.spy.dialogs.LayoutSpyDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ControlSelector {
    private static final int EDGE_SIZE = 4;
    private Shell overlay;
    private LocalResourceManager resources;
    private Color selectionRectangleColor;
    private Display display;
    private WritableValue<Control> currentSelection = new WritableValue(null, null);
    private Consumer<Control> callback;
    private Listener moveFilter = (Listener & Serializable)event -> this.mouseMove(event);
    private Listener selectFilter = (Listener & Serializable)event -> this.select(event);

    public ControlSelector(Consumer<Control> resultCallback) {
        this.callback = resultCallback;
        this.display = Display.getCurrent();
        this.overlay = new Shell(16392);
        this.overlay.addPaintListener((PaintListener & Serializable)paintEvent -> this.paint(paintEvent));
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.overlay);
        this.selectionRectangleColor = this.resources.createColor(new RGB(255, 255, 0));
        this.display.addFilter(5, this.moveFilter);
        this.display.addFilter(3, this.selectFilter);
        this.overlay.addDisposeListener((DisposeListener & Serializable)disposeEvent -> this.disposed(disposeEvent));
        LayoutSpyDialog.createFactory((Widget)this.overlay).create(() -> this.currentSelection.getValue(), this::updateRegion);
    }

    private void updateRegion(Control newControl) {
        if (newControl == null) {
            this.overlay.setVisible(false);
            return;
        }
        this.overlay.setBounds(newControl.getMonitor().getClientArea());
        Rectangle parentBoundsWrtDisplay = GeometryUtil.getDisplayBounds(newControl);
        Rectangle parentBoundsWrtOverlay = Geometry.toControl((Control)this.overlay, (Rectangle)parentBoundsWrtDisplay);
        Rectangle innerBoundsWrtOverlay = Geometry.copy((Rectangle)parentBoundsWrtOverlay);
        Geometry.expand((Rectangle)innerBoundsWrtOverlay, (int)-4, (int)-4, (int)-4, (int)-4);
        this.overlay.setVisible(true);
    }

    private void disposed(DisposeEvent e) {
        this.currentSelection.dispose();
        this.display.removeFilter(5, this.moveFilter);
        this.display.removeFilter(3, this.selectFilter);
    }

    private void select(Event e) {
        this.closeWithResult((Control)this.currentSelection.getValue());
        e.doit = false;
    }

    private void closeWithResult(Control result) {
        this.display.removeFilter(5, this.moveFilter);
        this.display.removeFilter(3, this.selectFilter);
        this.overlay.dispose();
        this.callback.accept(result);
    }

    public static Control findControl(Display displayToSearch, Shell toIgnore, Point locationToFind) {
        Shell[] shells = displayToSearch.getShells();
        ArrayList<Shell> shellList = new ArrayList<Shell>();
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell next = shellArray[n2];
            if (next != toIgnore) {
                shellList.add(next);
            }
            ++n2;
        }
        shells = shellList.toArray(new Shell[shellList.size()]);
        return ControlSelector.findControl((Control[])shells, locationToFind);
    }

    public static Control findControl(Composite toSearch, Point locationToFind) {
        Control[] children = toSearch.getChildren();
        return ControlSelector.findControl(children, locationToFind);
    }

    public static Control findControl(Control[] toSearch, Point locationToFind) {
        int idx = toSearch.length - 1;
        while (idx >= 0) {
            Rectangle bounds;
            Control next = toSearch[idx];
            if (!next.isDisposed() && next.isVisible() && (bounds = GeometryUtil.getDisplayBounds(next)).contains(locationToFind)) {
                Control result;
                if (next instanceof Composite && (result = ControlSelector.findControl((Composite)next, locationToFind)) != null) {
                    return result;
                }
                return next;
            }
            --idx;
        }
        return null;
    }

    private void mouseMove(Event e) {
        Control control;
        Point globalPoint = new Point(e.x, e.y);
        if (e.widget instanceof Control) {
            control = (Control)e.widget;
            globalPoint = control.toDisplay(globalPoint);
        }
        control = ControlSelector.findControl(Display.getCurrent(), this.overlay, globalPoint);
        this.currentSelection.setValue((Object)control);
    }

    protected void paint(PaintEvent e) {
        e.gc.setBackground(this.selectionRectangleColor);
        e.gc.fillRectangle(this.overlay.getClientArea());
    }
}

