/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.internal.ui.rulers.RulerDragTracker;
import org.eclipse.gef.internal.ui.rulers.RulerFigure;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class RulerEditPart
extends AbstractGraphicalEditPart {
    protected GraphicalViewer diagramViewer;
    private AccessibleEditPart accPart;
    private RulerProvider rulerProvider;
    private boolean horizontal;
    private RulerChangeListener listener = new RulerChangeListener.Stub(){

        public void notifyGuideReparented(Object guide) {
            RulerEditPart.this.handleGuideReparented(guide);
        }

        public void notifyUnitsChanged(int newUnit) {
            RulerEditPart.this.handleUnitsChanged(newUnit);
        }
    };

    public RulerEditPart(Object model) {
        this.setModel(model);
    }

    public void activate() {
        this.getRulerProvider().addRulerChangeListener(this.listener);
        this.getRulerFigure().setZoomManager(this.getZoomManager());
        super.activate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", new RulerSelectionPolicy());
    }

    protected IFigure createFigure() {
        RulerFigure ruler = new RulerFigure(this.isHorizontal(), this.getRulerProvider().getUnit());
        if (ruler.getUnit() == 2) {
            ruler.setInterval(100, 2);
        }
        return ruler;
    }

    public void deactivate() {
        super.deactivate();
        this.getRulerProvider().removeRulerChangeListener(this.listener);
        this.rulerProvider = null;
        this.getRulerFigure().setZoomManager(null);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    e.result = RulerEditPart.this.isHorizontal() ? GEFMessages.get().Ruler_Horizontal_Label : GEFMessages.get().Ruler_Vertical_Label;
                }

                public void getDescription(AccessibleEvent e) {
                    e.result = GEFMessages.get().Ruler_Desc;
                }
            };
        }
        return this.accPart;
    }

    protected GraphicalViewer getDiagramViewer() {
        return this.diagramViewer;
    }

    public DragTracker getDragTracker(Request request) {
        if (request.getType().equals("selection") && ((SelectionRequest)request).getLastButtonPressed() != 1) {
            return null;
        }
        return new RulerDragTracker(this);
    }

    public IFigure getGuideLayer() {
        LayerManager lm = (LayerManager)this.diagramViewer.getEditPartRegistry().get(LayerManager.ID);
        if (lm != null) {
            return lm.getLayer("Guide Layer");
        }
        return null;
    }

    protected List getModelChildren() {
        return this.getRulerProvider().getGuides();
    }

    protected RulerFigure getRulerFigure() {
        return (RulerFigure)this.getFigure();
    }

    public RulerProvider getRulerProvider() {
        return this.rulerProvider;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request.getType().equals("move")) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)this.diagramViewer.getProperty(ZoomManager.class.toString());
    }

    public void handleGuideReparented(Object guide) {
        this.refreshChildren();
        EditPart guidePart = (EditPart)this.getViewer().getEditPartRegistry().get(guide);
        if (guidePart != null) {
            this.getViewer().select(guidePart);
        }
    }

    public void handleUnitsChanged(int newUnit) {
        this.getRulerFigure().setUnit(newUnit);
        if (newUnit == 2) {
            this.getRulerFigure().setInterval(100, 2);
        } else {
            this.getRulerFigure().setInterval(0, 0);
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setParent(EditPart parent) {
        super.setParent(parent);
        if (this.getParent() != null && this.diagramViewer == null) {
            this.diagramViewer = (GraphicalViewer)this.getViewer().getProperty(GraphicalViewer.class.toString());
            RulerProvider hProvider = (RulerProvider)this.diagramViewer.getProperty("horizontal ruler");
            if (hProvider != null && hProvider.getRuler() == this.getModel()) {
                this.rulerProvider = hProvider;
                this.horizontal = true;
            } else {
                this.rulerProvider = (RulerProvider)this.diagramViewer.getProperty("vertical ruler");
            }
        }
    }

    public static class RulerSelectionPolicy
    extends SelectionEditPolicy {
        protected void hideFocus() {
            ((RulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void hideSelection() {
            ((RulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void showFocus() {
            ((RulerFigure)this.getHostFigure()).setDrawFocus(true);
        }

        protected void showSelection() {
            ((RulerFigure)this.getHostFigure()).setDrawFocus(true);
        }
    }
}

