/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.filters.CommonFilterLabelProvider;
import org.eclipse.ui.internal.navigator.filters.ContentDescriptorContentProvider;
import org.eclipse.ui.internal.navigator.filters.CustomizationTab;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ContentExtensionsTab
extends CustomizationTab {
    private static final long serialVersionUID = 1L;

    protected ContentExtensionsTab(Composite parent, INavigatorContentService aContentService) {
        super(parent, aContentService);
        this.createControl();
    }

    private void createControl() {
        this.createInstructionsLabel(CommonNavigatorMessages.CommonFilterSelectionDialog_Select_the_available_extensions);
        this.createTable();
        this.getTableViewer().setContentProvider((IContentProvider)new ContentDescriptorContentProvider());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new CommonFilterLabelProvider());
        this.getTableViewer().setInput((Object)this.getContentService());
        this.updateCheckedState();
    }

    private void updateCheckedState() {
        INavigatorContentDescriptor[] visibleExtensions = this.getContentService().getVisibleExtensions();
        int i = 0;
        while (i < visibleExtensions.length) {
            if (this.getContentService().isActive(visibleExtensions[i].getId())) {
                this.getTableViewer().setChecked((Object)visibleExtensions[i], true);
            }
            ++i;
        }
    }
}

