/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.chart.basic;

import org.eclipse.rap.addons.chart.Chart;
import org.eclipse.rap.addons.chart.basic.MapDataItem;
import org.eclipse.rap.addons.chart.internal.ColorUtil;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class MapChart
extends Chart {
    private static final String PROP_TOPOJSON_JS_URL = "org.eclipse.rap.addons.chart.topojsonJsUrl";
    private static final String DEF_TOPOJSON_JS_URL = "https://cdnjs.cloudflare.com/ajax/libs/topojson/1.6.20/topojson.min.js";
    private boolean showGraticule;
    private double scaleFactor = 1.0;
    private double longitude;
    private double latitude;

    public MapChart(Composite parent, int style) {
        super(parent, style, "topojson-world");
        this.requireJs(System.getProperty(PROP_TOPOJSON_JS_URL, DEF_TOPOJSON_JS_URL));
        this.requireJs(this.registerResource("chart/topojson/topojson-world.js"));
        this.requireCss(this.registerResource("resources/topojson-world.css"));
        this.setOption("dataPath", this.registerResource("resources/world-110m.json"));
    }

    public MapChart(Composite parent, int style, String path) {
        super(parent, style, "topojson-world");
        ParamCheck.notNullOrEmpty((String)path, (String)"path");
        this.requireJs(System.getProperty(PROP_TOPOJSON_JS_URL, DEF_TOPOJSON_JS_URL));
        this.requireJs(this.registerResource("chart/topojson/topojson-world.js"));
        this.requireCss(this.registerResource("resources/topojson-world.css"));
        this.setOption("dataPath", path);
    }

    public void setColors(RGB[] colors) {
        this.checkWidget();
        JsonArray json = new JsonArray();
        RGB[] rGBArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            RGB color = rGBArray[n2];
            json.add(ColorUtil.toHtmlString(color));
            ++n2;
        }
        this.setOption("colors", (JsonValue)json);
    }

    public void setShowGraticule(boolean show) {
        this.checkWidget();
        if (show != this.showGraticule) {
            this.showGraticule = show;
            this.setOption("showGraticule", show);
        }
    }

    public boolean getShowGraticule() {
        this.checkWidget();
        return this.showGraticule;
    }

    public void setScaleFactor(double scaleFactor) {
        this.checkWidget();
        if (scaleFactor <= 0.0) {
            SWT.error((int)5);
        }
        if (scaleFactor != this.scaleFactor) {
            this.scaleFactor = scaleFactor;
            this.setOption("scaleFactor", scaleFactor);
        }
    }

    public double getScaleFactor() {
        this.checkWidget();
        return this.scaleFactor;
    }

    public void setCenter(double longitude, double latitude) {
        this.checkWidget();
        if (longitude != this.longitude || latitude != this.latitude) {
            this.longitude = longitude;
            this.latitude = latitude;
            this.setOption("center", (JsonValue)new JsonArray().add(longitude).add(latitude));
        }
    }

    public double[] getCenter() {
        this.checkWidget();
        return new double[]{this.longitude, this.latitude};
    }

    public void setItems(MapDataItem ... items) {
        JsonObject values = new JsonObject();
        MapDataItem[] mapDataItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MapDataItem item = mapDataItemArray[n2];
            values.add(item.getCountry(), (JsonValue)MapChart.toJson(item));
            ++n2;
        }
        this.setOption("countries", (JsonValue)values);
    }

    private static JsonObject toJson(MapDataItem item) {
        JsonObject json = new JsonObject();
        if (item.text != null) {
            json.add("label", item.text);
        }
        if (item.color != null) {
            json.add("color", ColorUtil.toHtmlString(item.color));
        }
        return json;
    }
}

