/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ObjectReader {
    private static final Log log = LogFactory.getLog(ObjectReader.class);
    private XByteBuffer buffer;
    protected long lastAccess = System.currentTimeMillis();
    protected boolean accessed = false;
    private boolean cancelled;

    public ObjectReader(int packetSize) {
        this.buffer = new XByteBuffer(packetSize, true);
    }

    public ObjectReader(SocketChannel channel) {
        this(channel.socket());
    }

    public ObjectReader(Socket socket) {
        try {
            this.buffer = new XByteBuffer(socket.getReceiveBufferSize(), true);
        }
        catch (IOException iOException) {
            log.warn("Unable to retrieve the socket receiver buffer size, setting to default 43800 bytes.");
            this.buffer = new XByteBuffer(43800, true);
        }
    }

    public synchronized void access() {
        this.accessed = true;
        this.lastAccess = System.currentTimeMillis();
    }

    public synchronized void finish() {
        this.accessed = false;
        this.lastAccess = System.currentTimeMillis();
    }

    public boolean isAccessed() {
        return this.accessed;
    }

    public int append(ByteBuffer data, int len, boolean count) throws IOException {
        this.buffer.append(data, len);
        int pkgCnt = -1;
        if (count) {
            pkgCnt = this.buffer.countPackages();
        }
        return pkgCnt;
    }

    public int append(byte[] data, int off, int len, boolean count) throws IOException {
        this.buffer.append(data, off, len);
        int pkgCnt = -1;
        if (count) {
            pkgCnt = this.buffer.countPackages();
        }
        return pkgCnt;
    }

    public ChannelMessage[] execute() throws IOException {
        int pkgCnt = this.buffer.countPackages();
        ChannelMessage[] result = new ChannelMessage[pkgCnt];
        int i = 0;
        while (i < pkgCnt) {
            ChannelData data = this.buffer.extractPackage(true);
            result[i] = data;
            ++i;
        }
        return result;
    }

    public int bufferSize() {
        return this.buffer.getLength();
    }

    public boolean hasPackage() {
        return this.buffer.countPackages(true) > 0;
    }

    public int count() {
        return this.buffer.countPackages();
    }

    public void close() {
        this.buffer = null;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

