/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.internal.xpath;

import java.util.Locale;
import java.util.Objects;
import org.eclipse.e4.emf.internal.xpath.EObjectPropertyPointer;
import org.eclipse.e4.emf.internal.xpath.EStructuralFeatureOwnerPointer;
import org.eclipse.e4.emf.internal.xpath.EStructuralFeaturePointer;
import org.eclipse.e4.emf.internal.xpath.helper.JXPathEObjectInfo;
import org.eclipse.rap.e4.apache.jxpath.JXPathIntrospector;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;

public class EObjectPointer
extends EStructuralFeatureOwnerPointer {
    private QName name;
    private Object bean;
    private JXPathEObjectInfo beanInfo;
    private static final long serialVersionUID = -8227317938284982440L;

    public EObjectPointer(QName name, Object bean, JXPathEObjectInfo beanInfo, Locale locale) {
        super(null, locale);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public EObjectPointer(NodePointer parent, QName name, Object bean, JXPathEObjectInfo beanInfo) {
        super(parent);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    @Override
    public EStructuralFeaturePointer getPropertyPointer() {
        return new EObjectPropertyPointer((NodePointer)this, this.beanInfo);
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public Object getBaseValue() {
        return this.bean;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object object) {
        int iOther;
        if (object == this) {
            return true;
        }
        if (!(object instanceof EObjectPointer)) {
            return false;
        }
        EObjectPointer other = (EObjectPointer)object;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int n = iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        if (iThis != iOther) {
            return false;
        }
        if (this.bean instanceof Number || this.bean instanceof String || this.bean instanceof Boolean) {
            return this.bean.equals(other.bean);
        }
        return this.bean == other.bean;
    }

    @Override
    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        if (this.bean == null) {
            return "null()";
        }
        if (this.bean instanceof Number) {
            String string = this.bean.toString();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (this.bean instanceof Boolean) {
            return (Boolean)this.bean != false ? "true()" : "false()";
        }
        if (this.bean instanceof String) {
            return "'" + String.valueOf(this.bean) + "'";
        }
        return "/";
    }
}

