/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class DemoTableViewPart
extends ViewPart {
    private static final int ROWS = 40;
    private static final int COLUMNS = 10;
    private TableViewer viewer;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        Table table = this.viewer.getTable();
        this.viewer.setColumnProperties(this.initColumnProperties(table));
        this.viewer.setInput((Object)this);
        this.viewer.getTable().setHeaderVisible(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private String[] initColumnProperties(Table table) {
        String[] result = new String[10];
        int i = 0;
        while (i < 10) {
            TableColumn tableColumn = new TableColumn(table, 0);
            result[i] = "Column" + i;
            tableColumn.setText(result[i]);
            if (i == 2) {
                tableColumn.setWidth(190);
            } else {
                tableColumn.setWidth(70);
            }
            ++i;
        }
        return result;
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String[]> buffer = new ArrayList<String[]>();
            int i = 0;
            while (i < 40) {
                String[] row = new String[10];
                int j = 0;
                while (j < 10) {
                    row[j] = "Item" + i + "-" + j;
                    ++j;
                }
                buffer.add(row);
                ++i;
            }
            Object[] result = new Object[buffer.size()];
            buffer.toArray(result);
            return result;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String[] row = (String[])element;
            String result = row[columnIndex];
            return result;
        }
    }
}

