/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collection;
import org.eclipse.equinox.internal.event.EventAdminMsg;
import org.eclipse.equinox.internal.event.LogTracker;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventHandlerWrapper {
    final ServiceReference<EventHandler> reference;
    private final LogTracker log;
    final BundleContext context;
    private EventHandler handler;
    private String[] topics;
    private Filter filter;

    public EventHandlerWrapper(ServiceReference<EventHandler> reference, BundleContext context, LogTracker log) {
        this.reference = reference;
        this.context = context;
        this.log = log;
    }

    public synchronized boolean init() {
        this.topics = null;
        this.filter = null;
        Object o = this.reference.getProperty("event.topics");
        if (o instanceof String) {
            this.topics = new String[]{(String)o};
        } else if (o instanceof String[]) {
            this.topics = (String[])o;
        } else if (o instanceof Collection) {
            try {
                Collection c = (Collection)o;
                this.topics = c.toArray(new String[c.size()]);
            }
            catch (ArrayStoreException e) {
                this.log.log(1, NLS.bind((String)EventAdminMsg.EVENT_INVALID_HANDLER_TOPICS, (Object)o), e);
            }
        }
        if (this.topics == null) {
            return false;
        }
        o = this.reference.getProperty("event.filter");
        if (o instanceof String) {
            try {
                this.filter = this.context.createFilter((String)o);
            }
            catch (InvalidSyntaxException e) {
                this.log.log(1, NLS.bind((String)EventAdminMsg.EVENT_INVALID_HANDLER_FILTER, (Object)o), e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        EventHandlerWrapper eventHandlerWrapper = this;
        synchronized (eventHandlerWrapper) {
            if (this.handler == null) {
                return;
            }
            this.handler = null;
        }
        try {
            this.context.ungetService(this.reference);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public synchronized String[] getTopics() {
        return this.topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventHandler getHandler() {
        EventHandlerWrapper eventHandlerWrapper = this;
        synchronized (eventHandlerWrapper) {
            if (this.handler != null) {
                return this.handler;
            }
        }
        EventHandler tempHandler = null;
        try {
            tempHandler = AccessController.doPrivileged(new PrivilegedAction<EventHandler>(){

                @Override
                public EventHandler run() {
                    return (EventHandler)EventHandlerWrapper.this.context.getService(EventHandlerWrapper.this.reference);
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        EventHandlerWrapper eventHandlerWrapper2 = this;
        synchronized (eventHandlerWrapper2) {
            if (this.handler == null) {
                this.handler = tempHandler;
                return this.handler;
            }
            tempHandler = this.handler;
        }
        try {
            this.context.ungetService(this.reference);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return tempHandler;
    }

    private synchronized Filter getFilter() {
        return this.filter;
    }

    public void handleEvent(Event event, Permission perm) {
        Bundle bundle = this.reference.getBundle();
        if (bundle == null) {
            return;
        }
        Filter eventFilter = this.getFilter();
        if (eventFilter != null && !event.matches(eventFilter)) {
            return;
        }
        if (perm != null && !bundle.hasPermission((Object)perm)) {
            return;
        }
        EventHandler handlerService = this.getHandler();
        if (handlerService == null) {
            return;
        }
        try {
            handlerService.handleEvent(event);
        }
        catch (Throwable t2) {
            LogTopicException t2;
            if (event.getTopic().startsWith("org/osgi/service/log/LogEntry")) {
                Object exception = event.getProperty("exception");
                if (exception instanceof LogTopicException) {
                    return;
                }
                t2 = new LogTopicException(t2);
            }
            this.log.log(1, NLS.bind((String)EventAdminMsg.EVENT_DISPATCH_HANDLER_EXCEPTION, (Object)event, (Object)handlerService), t2);
        }
    }

    static class LogTopicException
    extends RuntimeException {
        private static final long serialVersionUID = -2386940335620739632L;

        public LogTopicException(Throwable cause) {
            super(cause);
        }
    }
}

