/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.LinkedList;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.ScrLogger;

class ComponentActorThread
implements Runnable {
    private static final Runnable TERMINATION_TASK = new Runnable(){

        @Override
        public void run() {
        }

        public String toString() {
            return "Component Actor Terminator";
        }
    };
    private final LinkedList<Runnable> tasks = new LinkedList();
    private final ScrLogger logger;

    ComponentActorThread(ScrLogger log) {
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.logger.log(InternalLogger.Level.DEBUG, "Starting ComponentActorThread", null);
        while (true) {
            Runnable task;
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                while (this.tasks.isEmpty()) {
                    boolean interrupted = Thread.interrupted();
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                    }
                }
                task = this.tasks.removeFirst();
            }
            try {
                if (task == TERMINATION_TASK) {
                    this.logger.log(InternalLogger.Level.DEBUG, "Shutting down ComponentActorThread", null);
                    return;
                }
                this.logger.log(InternalLogger.Level.DEBUG, "Running task: " + task, null);
                task.run();
                continue;
            }
            catch (Throwable t) {
                this.logger.log(InternalLogger.Level.ERROR, "Unexpected problem executing task " + task, t);
                continue;
            }
            finally {
                linkedList = this.tasks;
                synchronized (linkedList) {
                    this.tasks.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void terminate() {
        this.schedule(TERMINATION_TASK);
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            while (!this.tasks.isEmpty()) {
                boolean interrupted = Thread.interrupted();
                try {
                    this.tasks.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.logger.log(InternalLogger.Level.ERROR, "Interrupted exception waiting for queue to empty", e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable task) {
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            this.logger.log(InternalLogger.Level.DEBUG, "Adding task [{0}] as #{1} in the queue", null, task, this.tasks.size());
            this.tasks.notifyAll();
        }
    }
}

