/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.reliablefile.ReliableFile;
import org.eclipse.equinox.internal.cm.reliablefile.ReliableFileInputStream;
import org.eclipse.equinox.internal.cm.reliablefile.ReliableFileOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationStore {
    private final ConfigurationAdminFactory configurationAdminFactory;
    private static final String STORE_DIR = "store";
    private static final String DATA_PRE = "data";
    private static final String CFG_EXT = ".cfg";
    private final Map<String, ConfigurationImpl> configurations = new HashMap<String, ConfigurationImpl>();
    private int createdPidCount = 0;
    private final File store;

    public ConfigurationStore(ConfigurationAdminFactory configurationAdminFactory, BundleContext context) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.store = context.getDataFile(STORE_DIR);
        if (this.store == null) {
            return;
        }
        this.store.mkdir();
        File[] configurationFiles = this.store.listFiles();
        int i = 0;
        while (i < configurationFiles.length) {
            String configurationFileName = configurationFiles[i].getName();
            if (configurationFileName.endsWith(CFG_EXT)) {
                boolean deleteFile;
                block33: {
                    ReliableFileInputStream ris;
                    block35: {
                        ris = null;
                        ObjectInputStream ois = null;
                        deleteFile = false;
                        try {
                            Boolean boundProp;
                            ris = new ReliableFileInputStream(configurationFiles[i]);
                            ois = new ObjectInputStream(ris);
                            Dictionary dictionary = (Dictionary)ois.readObject();
                            String location = (String)dictionary.get("service.bundleLocation");
                            if (location != null && context.getBundle(location) == null && (boundProp = (Boolean)dictionary.remove("org.eclipse.equinox.cm.location.bound")) != null && boundProp.booleanValue()) {
                                dictionary.remove("service.bundleLocation");
                            }
                            ConfigurationImpl config = new ConfigurationImpl(configurationAdminFactory, this, dictionary, configurationFiles[i]);
                            this.configurations.put(config.getPid(), config);
                        }
                        catch (IOException e) {
                            String message = e.getMessage();
                            String pid = configurationFileName.substring(0, configurationFileName.length() - 4);
                            String errorMessage = "{Configuration Admin - pid = " + pid + "} could not be restored." + (message == null ? "" : " " + message);
                            configurationAdminFactory.log(1, errorMessage);
                            deleteFile = true;
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (ris != null) {
                                try {
                                    ((InputStream)ris).close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block33;
                        }
                        catch (ClassNotFoundException e) {
                            block34: {
                                try {
                                    configurationAdminFactory.log(1, e.getMessage());
                                    if (ois == null) break block34;
                                }
                                catch (Throwable throwable) {
                                    if (ois != null) {
                                        try {
                                            ois.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (ris != null) {
                                        try {
                                            ((InputStream)ris).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    throw throwable;
                                }
                                try {
                                    ois.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (ris != null) {
                                try {
                                    ((InputStream)ris).close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block33;
                        }
                        if (ois == null) break block35;
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (ris != null) {
                        try {
                            ((InputStream)ris).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (deleteFile) {
                    ReliableFile.delete(configurationFiles[i]);
                    configurationFiles[i].delete();
                }
            }
            ++i;
        }
    }

    public Object saveConfiguration(String pid, ConfigurationImpl config, final Object token) throws IOException {
        if (this.store == null) {
            return null;
        }
        config.checkLocked();
        final Dictionary<String, Object> configProperties = config.getAllProperties(true);
        if (configProperties == null) {
            return null;
        }
        try {
            final File storeCopy = this.store;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    File toFile = token == null ? File.createTempFile(ConfigurationStore.DATA_PRE, ConfigurationStore.CFG_EXT, storeCopy) : (File)token;
                    ConfigurationStore.this.writeConfigurationFile(toFile, configProperties);
                    return toFile;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    void writeConfigurationFile(File configFile, Dictionary<String, Object> configProperties) throws IOException {
        ReliableFileOutputStream ros = null;
        ObjectOutputStream oos = null;
        try {
            configFile.createNewFile();
            ros = new ReliableFileOutputStream(configFile);
            oos = new ObjectOutputStream(ros);
            oos.writeObject(configProperties);
        }
        catch (Throwable throwable) {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (ros != null) {
                try {
                    ((OutputStream)ros).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (oos != null) {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
        if (ros != null) {
            try {
                ((OutputStream)ros).close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void removeConfiguration(String pid, final Object token) {
        this.configurations.remove(pid);
        if (this.store == null || token == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ConfigurationStore.this.deleteConfigurationFile((File)token);
                return null;
            }
        });
    }

    void deleteConfigurationFile(File configFile) {
        ReliableFile.delete(configFile);
        configFile.delete();
    }

    public synchronized ConfigurationImpl getConfiguration(String pid, String location, boolean bind) {
        ConfigurationImpl config = this.configurations.get(pid);
        if (config == null) {
            config = new ConfigurationImpl(this.configurationAdminFactory, this, null, pid, location, bind);
            this.configurations.put(pid, config);
        }
        return config;
    }

    public synchronized ConfigurationImpl createFactoryConfiguration(String factoryPid, String location, boolean bind) {
        String pid = String.valueOf(factoryPid) + "-" + new Date().getTime() + "-" + this.createdPidCount++;
        ConfigurationImpl config = new ConfigurationImpl(this.configurationAdminFactory, this, factoryPid, pid, location, bind);
        this.configurations.put(pid, config);
        return config;
    }

    public synchronized ConfigurationImpl findConfiguration(String pid) {
        return this.configurations.get(pid);
    }

    public synchronized ConfigurationImpl[] getFactoryConfigurations(String factoryPid) {
        ArrayList<ConfigurationImpl> resultList = new ArrayList<ConfigurationImpl>();
        for (ConfigurationImpl config : this.configurations.values()) {
            String otherFactoryPid = config.getFactoryPid();
            if (otherFactoryPid == null || !otherFactoryPid.equals(factoryPid)) continue;
            resultList.add(config);
        }
        return resultList.toArray(new ConfigurationImpl[resultList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationImpl[] listConfigurations(Filter filter) {
        ArrayList<ConfigurationImpl> resultList = new ArrayList<ConfigurationImpl>();
        ConfigurationStore configurationStore = this;
        synchronized (configurationStore) {
            resultList.addAll(this.configurations.values());
        }
        Iterator it = resultList.iterator();
        while (it.hasNext()) {
            ConfigurationImpl config = (ConfigurationImpl)it.next();
            Dictionary<String, Object> properties = config.getAllProperties(false);
            if (properties != null && filter.match(properties)) continue;
            it.remove();
        }
        int size = resultList.size();
        return size == 0 ? null : resultList.toArray(new ConfigurationImpl[size]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindConfigurations(Bundle bundle) {
        ConfigurationImpl[] copy;
        ConfigurationStore configurationStore = this;
        synchronized (configurationStore) {
            copy = this.configurations.values().toArray(new ConfigurationImpl[this.configurations.size()]);
        }
        ConfigurationImpl[] configurationImplArray = copy;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationImpl config = configurationImplArray[n2];
            config.unbind(bundle);
            ++n2;
        }
    }
}

