/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    private static final int TABS_SPACING = 1;
    private static final int IMAGE_TEXT_SPACING = 4;
    private static final int ITEM_BORDER = 1;
    static final int SELECTED_ITEM_BORDER = 3;
    private final TabFolder parent;
    private Control control;
    private String toolTipText;

    public TabItem(TabFolder parent, int style) {
        super(parent, TabItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, TabItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != this.parent.getSelectionIndex()) {
            if (newControl != null) {
                newControl.setVisible(false);
            }
        } else {
            if (newControl != null) {
                newControl.setBounds(this.parent.getClientArea());
                newControl.setVisible(true);
            }
            if (oldControl != null) {
                oldControl.setVisible(false);
            }
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle result = new Rectangle(0, 0, 0, 0);
        int index = this.parent.indexOf(this);
        if (index != -1) {
            Image image;
            int selectionIndex = this.parent.getSelectionIndex();
            boolean selected = index == selectionIndex;
            Rectangle padding = this.parent.getItemPadding(selected);
            String text = this.getText();
            if (text != null) {
                Point extent = TextSizeUtil.stringExtent(this.parent.getFont(), text);
                result.width = extent.x;
                result.height = extent.y;
            }
            if ((image = this.getImage()) != null) {
                Rectangle imageSize = image.getBounds();
                result.width += imageSize.width + 4;
                result.height = Math.max(result.height, imageSize.height);
            }
            result.width += 2 + padding.width;
            result.height += 1 + padding.height;
            if (selected) {
                result.height += 3;
            }
            if (selectionIndex != -1 && (index + 1 == selectionIndex || index - 1 == selectionIndex)) {
                --result.width;
            }
            if (this.isBarTop()) {
                if (index != selectionIndex) {
                    result.y += 3;
                }
            } else {
                result.y = this.parent.getBounds().height - 2 * this.parent.getBorderWidth() - result.height;
                if (index != selectionIndex) {
                    result.y -= 3;
                }
            }
            if (index > 0) {
                TabItem leftItem = this.parent.getItem(index - 1);
                Rectangle leftItemBounds = leftItem.getBounds();
                result.x = leftItemBounds.x + leftItemBounds.width + 1;
                if (index == selectionIndex || index - 1 == selectionIndex) {
                    --result.x;
                }
            }
        }
        return result;
    }

    private boolean isBarTop() {
        return (this.parent.getStyle() & 0x400) == 0;
    }

    public void setImage(Image image) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index > -1) {
            super.setImage(image);
        }
    }

    public void setToolTipText(String toolTip) {
        this.checkWidget();
        this.toolTipText = toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseParent() {
        super.releaseParent();
        this.parent.destroyItem(this);
    }

    private static int checkStyle(int style) {
        int result = 0;
        if (style > 0) {
            result = style;
        }
        return result;
    }
}

