/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.droptargetkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.internal.dnd.dragsourcekit.DNDLCAUtil;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Widget;

public final class DropTargetLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.DropTarget";
    private static final String PROP_TRANSFER = "transfer";
    private static final String PROP_DRAG_ENTER_LISTENER = "DragEnter";
    private static final String PROP_DRAG_OVER_LISTENER = "DragOver";
    private static final String PROP_DRAG_LEAVE_LISTENER = "DragLeave";
    private static final String PROP_DRAG_OPERATION_CHANGED_LISTENER = "DragOperationChanged";
    private static final String PROP_DROP_ACCEPT_LISTENER = "DropAccept";
    private static final Transfer[] DEFAULT_TRANSFER = new Transfer[0];

    public void preserveValues(Widget widget) {
        DropTarget dropTarget = (DropTarget)widget;
        WidgetLCAUtil.preserveProperty((Widget)dropTarget, PROP_TRANSFER, dropTarget.getTransfer());
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DRAG_ENTER_LISTENER, EventLCAUtil.isListening(dropTarget, 2002));
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DRAG_OVER_LISTENER, EventLCAUtil.isListening(dropTarget, 2004));
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DRAG_LEAVE_LISTENER, EventLCAUtil.isListening(dropTarget, 2003));
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DRAG_OPERATION_CHANGED_LISTENER, EventLCAUtil.isListening(dropTarget, 2005));
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DROP_ACCEPT_LISTENER, EventLCAUtil.isListening(dropTarget, 2007));
    }

    public void readData(Widget widget) {
    }

    public void renderInitialization(Widget widget) throws IOException {
        DropTarget dropTarget = (DropTarget)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(dropTarget);
        clientObject.create(TYPE);
        clientObject.set("control", WidgetUtil.getId(dropTarget.getControl()));
        clientObject.set("style", DNDLCAUtil.convertOperations(dropTarget.getStyle()));
    }

    public void renderChanges(Widget widget) throws IOException {
        DropTarget dropTarget = (DropTarget)widget;
        DropTargetLCA.renderTransfer(dropTarget);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DRAG_ENTER_LISTENER, EventLCAUtil.isListening(dropTarget, 2002), false);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DRAG_OVER_LISTENER, EventLCAUtil.isListening(dropTarget, 2004), false);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DRAG_LEAVE_LISTENER, EventLCAUtil.isListening(dropTarget, 2003), false);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DRAG_OPERATION_CHANGED_LISTENER, EventLCAUtil.isListening(dropTarget, 2005), false);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DROP_ACCEPT_LISTENER, EventLCAUtil.isListening(dropTarget, 2007), false);
    }

    private static void renderTransfer(DropTarget dropTarget) {
        Transfer[] newValue = dropTarget.getTransfer();
        if (WidgetLCAUtil.hasChanged(dropTarget, PROP_TRANSFER, newValue, DEFAULT_TRANSFER)) {
            JsonArray renderValue = DNDLCAUtil.convertTransferTypes(newValue);
            ClientObjectFactory.getClientObject(dropTarget).set(PROP_TRANSFER, renderValue);
        }
    }
}

