/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;

public final class ClientObject
implements IClientObject {
    private final String targetId;

    public ClientObject(String targetId) {
        this.targetId = targetId;
    }

    public void create(String type) {
        ClientObject.getWriter().appendCreate(this.targetId, type);
    }

    public void destroy() {
        ClientObject.getWriter().appendDestroy(this.targetId);
    }

    public void set(String name, int value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    public void set(String name, double value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    public void set(String name, boolean value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    public void set(String name, String value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    public void set(String name, JsonValue value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    public void listen(String eventName, boolean listen) {
        ClientObject.getWriter().appendListen(this.targetId, eventName, listen);
    }

    public void call(String method, JsonObject parameters) {
        ClientObject.getWriter().appendCall(this.targetId, method, parameters);
    }

    private static ProtocolMessageWriter getWriter() {
        return ContextProvider.getProtocolWriter();
    }
}

