/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.clientscripting;

import java.lang.reflect.Method;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ClientScriptingSupport {
    private static final String CLIENT_LISTENER_CLASS_NAME = "org.eclipse.rap.clientscripting.ClientListener";

    public static boolean isClientListener(Listener listener) {
        return CLIENT_LISTENER_CLASS_NAME.equals(listener.getClass().getName());
    }

    public static void addClientListenerTo(Widget widget, int eventType, Listener listener) {
        ClientScriptingSupport.invokeMethod("addTo", widget, eventType, listener);
    }

    public static void removeClientListenerFrom(Widget widget, int eventType, Listener listener) {
        ClientScriptingSupport.invokeMethod("removeFrom", widget, eventType, listener);
    }

    private static void invokeMethod(String methodName, Widget widget, int eventType, Listener listener) {
        try {
            Method method = ClientScriptingSupport.findMethod(methodName, listener);
            if (method != null) {
                method.setAccessible(true);
                method.invoke((Object)listener, widget, eventType);
            }
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    private static Method findMethod(String methodName, Listener listener) {
        Method[] declaredMethods;
        Method[] methodArray = declaredMethods = listener.getClass().getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ClientScriptingSupport.hasClientListenerSignature(methodName, method)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasClientListenerSignature(String methodName, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return method.getName().equals(methodName) && parameterTypes.length == 2 && parameterTypes[0] == Widget.class && parameterTypes[1] == Integer.TYPE;
    }

    private ClientScriptingSupport() {
    }
}

