/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.BrowserNavigationEvent;
import org.eclipse.rap.rwt.client.service.BrowserNavigationListener;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.lifecycle.PhaseEvent;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.eclipse.swt.SWT;

public final class BrowserNavigationImpl
implements BrowserNavigation,
PhaseListener,
UISessionListener {
    private static final String TYPE = "rwt.client.BrowserNavigation";
    private static final String PROP_NAVIGATION_LISTENER = "Navigation";
    private static final String PROP_ENTRIES = "entries";
    private static final String METHOD_ADD_TO_HISTORY = "addToHistory";
    private static final String EVENT_HISTORY_NAVIGATED_STATE = "state";
    private final UISession uiSession;
    private final List<HistoryEntry> entriesToAdd = new ArrayList<HistoryEntry>();
    private final Collection<BrowserNavigationListener> listeners = new LinkedHashSet<BrowserNavigationListener>();
    private boolean hasNavigationListener;

    public BrowserNavigationImpl() {
        ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle().addPhaseListener(this);
        this.uiSession = ContextProvider.getUISession();
        this.uiSession.addUISessionListener(this);
    }

    public void pushState(String state, String text) {
        ParamCheck.notNullOrEmpty(state, EVENT_HISTORY_NAVIGATED_STATE);
        this.entriesToAdd.add(new HistoryEntry(state, text));
    }

    public void addBrowserNavigationListener(BrowserNavigationListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        this.listeners.add(listener);
    }

    public void removeBrowserNavigationListener(BrowserNavigationListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        this.listeners.remove(listener);
    }

    public void afterPhase(PhaseEvent event) {
        if (this.uiSession == ContextProvider.getUISession()) {
            if (event.getPhaseId() == PhaseId.PREPARE_UI_ROOT && BrowserNavigationImpl.isStartup()) {
                this.processNavigationEvent();
            } else if (event.getPhaseId() == PhaseId.READ_DATA) {
                this.preserveNavigationListener();
            } else if (event.getPhaseId() == PhaseId.RENDER) {
                this.renderNavigationListener();
                this.renderAdd();
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (this.uiSession == ContextProvider.getUISession() && event.getPhaseId() == PhaseId.PROCESS_ACTION && !BrowserNavigationImpl.isStartup()) {
            this.processNavigationEvent();
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY;
    }

    public void beforeDestroy(UISessionEvent event) {
        ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle().removePhaseListener(this);
    }

    private static boolean isStartup() {
        JsonValue initializeHeader = ProtocolUtil.getClientMessage().getHeader("rwt_initialize");
        return JsonValue.TRUE.equals(initializeHeader);
    }

    private void processNavigationEvent() {
        if (ProtocolUtil.wasEventSent(TYPE, PROP_NAVIGATION_LISTENER)) {
            String state = ProtocolUtil.readEventPropertyValueAsString(TYPE, PROP_NAVIGATION_LISTENER, EVENT_HISTORY_NAVIGATED_STATE);
            BrowserNavigationEvent event = new BrowserNavigationEvent(this, state);
            this.notifyListeners(event);
        }
    }

    void notifyListeners(BrowserNavigationEvent event) {
        BrowserNavigationListener[] listeners;
        BrowserNavigationListener[] browserNavigationListenerArray = listeners = this.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            BrowserNavigationListener listener = browserNavigationListenerArray[n2];
            listener.navigated(event);
            ++n2;
        }
    }

    private BrowserNavigationListener[] getListeners() {
        return this.listeners.toArray(new BrowserNavigationListener[this.listeners.size()]);
    }

    private void preserveNavigationListener() {
        this.hasNavigationListener = !this.listeners.isEmpty();
    }

    private boolean getPreservedNavigationListener() {
        return this.hasNavigationListener;
    }

    private void renderNavigationListener() {
        boolean actual = !this.listeners.isEmpty();
        boolean preserved = this.getPreservedNavigationListener();
        if (preserved != actual) {
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            protocolWriter.appendListen(TYPE, PROP_NAVIGATION_LISTENER, actual);
        }
    }

    private void renderAdd() {
        if (!this.entriesToAdd.isEmpty()) {
            JsonObject parameters = new JsonObject().add(PROP_ENTRIES, this.entriesAsArray());
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            protocolWriter.appendCall(TYPE, METHOD_ADD_TO_HISTORY, parameters);
            this.entriesToAdd.clear();
        }
    }

    private JsonArray entriesAsArray() {
        HistoryEntry[] entries = this.getEntries();
        JsonArray result = new JsonArray();
        int i = 0;
        while (i < entries.length) {
            result.add(new JsonArray().add(entries[i].state).add(entries[i].title));
            ++i;
        }
        return result;
    }

    HistoryEntry[] getEntries() {
        return this.entriesToAdd.toArray(new HistoryEntry[this.entriesToAdd.size()]);
    }

    final class HistoryEntry {
        final String state;
        final String title;

        HistoryEntry(String state, String title) {
            this.state = state;
            this.title = title;
        }
    }
}

