/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.config;

import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.config.ValidationResult;
import org.eclipse.rap.ui.internal.launch.rwt.config.Validator;

class WebXmlLocationValidator
extends Validator {
    static final int ERR_WEB_XML_LOCATION_EMPTY = 8010;
    static final int ERR_WEB_XML_LOCATION_NOT_FOUND = 8011;

    WebXmlLocationValidator(RWTLaunchConfig config, ValidationResult validationResult) {
        super(config, validationResult);
    }

    void validate() {
        if (RWTLaunchConfig.LaunchTarget.WEB_XML.equals((Object)this.config.getLaunchTarget())) {
            String webXmlLocation = this.config.getWebXmlLocation();
            if (webXmlLocation.length() == 0) {
                this.addError("The location for the web.xml is empty.", 8010);
            } else {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (!root.exists(Path.fromPortableString((String)webXmlLocation))) {
                    String msg = MessageFormat.format("File {0} does not exist.", webXmlLocation);
                    this.addError(msg, 8011);
                }
            }
        }
    }
}

