/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.delegate;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.delegate.BrowserOpener;
import org.eclipse.rap.ui.internal.launch.rwt.delegate.LaunchCleanup;
import org.eclipse.rap.ui.internal.launch.rwt.delegate.LaunchTerminator;
import org.eclipse.rap.ui.internal.launch.rwt.delegate.RWTLaunch;
import org.eclipse.rap.ui.internal.launch.rwt.delegate.WebXmlProvider;
import org.eclipse.rap.ui.internal.launch.rwt.util.BundleFileLocator;
import org.eclipse.rap.ui.internal.launch.rwt.util.StringArrays;

public class RWTLaunchDelegate
extends JavaLaunchDelegate {
    private RWTLaunch launch;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor mon) throws CoreException {
        IProgressMonitor monitor = mon == null ? new NullProgressMonitor() : mon;
        this.initializeLaunch(launch);
        LaunchCleanup.register(launch);
        RWTLaunchConfig launchConfig = this.launch.getLaunchConfig();
        if (launchConfig.getOpenBrowser()) {
            BrowserOpener browserOpener = new BrowserOpener(launch);
            browserOpener.scheduleOpen();
        }
        LaunchTerminator.terminatePrevious(launch, monitor);
        new WebXmlProvider(this.launch).provide(monitor);
        if (!monitor.isCanceled()) {
            super.launch(configuration, mode, launch, mon);
        }
    }

    public String getMainTypeName(ILaunchConfiguration configuration) {
        return "org.eclipse.rap.ui.internal.launch.rwt.jetty.JettyLauncher";
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] result = super.getClasspath(configuration);
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.rap.ui.launch.rwt"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.continuation"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.http"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.io"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.security"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.server"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.servlet"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.util"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.webapp"));
        result = StringArrays.append(result, BundleFileLocator.locate("org.eclipse.jetty.xml"));
        result = StringArrays.append(result, BundleFileLocator.locate("javax.servlet"));
        return result;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) {
        String port = String.valueOf(this.launch.getPort());
        String webAppDirectory = this.launch.getWebAppPath().getAbsolutePath();
        return MessageFormat.format("{0} \"{1}\"", port, webAppDirectory);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String result = super.getVMArguments(configuration);
        result = String.valueOf(result) + " -Djetty.home=";
        result = String.valueOf(result) + "\"";
        result = String.valueOf(result) + this.launch.getJettyHomePath();
        result = String.valueOf(result) + "\"";
        return result;
    }

    void initializeLaunch(ILaunch genericLaunch) {
        this.launch = new RWTLaunch(genericLaunch);
        this.launch.setPort(this.determinePort());
    }

    int determinePort() {
        RWTLaunchConfig launchConfig = this.launch.getLaunchConfig();
        int result = launchConfig.getUseManualPort() ? launchConfig.getPort() : SocketUtil.findFreePort();
        return result;
    }
}

