/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.config;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rap.ui.internal.launch.rwt.RWTLaunchActivator;

public class ValidationResult {
    private final List<IStatus> results = new LinkedList<IStatus>();

    public void addError(String message, int code) {
        this.addStatus(4, message, code);
    }

    public void addWarning(String message, int code) {
        this.addStatus(2, message, code);
    }

    public IStatus[] getAll() {
        IStatus[] result = new IStatus[this.results.size()];
        this.results.toArray(result);
        return result;
    }

    public IStatus[] getErrors() {
        return this.getStates(4);
    }

    public IStatus[] getWarnings() {
        return this.getStates(2);
    }

    public boolean contains(int code) {
        IStatus[] all = this.getAll();
        boolean result = false;
        int i = 0;
        while (!result && i < all.length) {
            if (all[i].getCode() == code) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private void addStatus(int severity, String message, int code) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        Status status = new Status(severity, RWTLaunchActivator.getPluginId(), code, message, null);
        this.results.add((IStatus)status);
    }

    private IStatus[] getStates(int severity) {
        int count = this.countStates(severity);
        IStatus[] states = this.getAll();
        int index = 0;
        IStatus[] result = new IStatus[count];
        int i = 0;
        while (i < states.length) {
            if (states[i].matches(severity)) {
                result[index] = states[i];
                ++index;
            }
            ++i;
        }
        return result;
    }

    private int countStates(int severity) {
        int result = 0;
        IStatus[] states = this.getAll();
        int i = 0;
        while (i < states.length) {
            if (states[i].matches(severity)) {
                ++result;
            }
            ++i;
        }
        return result;
    }
}

