/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.shortcut;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchShortcut;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.shortcut.EntryPointSearchEngine;
import org.eclipse.rap.ui.internal.launch.rwt.shortcut.JavaElementUtil;
import org.eclipse.rap.ui.internal.launch.rwt.shortcut.LaunchConfigCreator;
import org.eclipse.rap.ui.internal.launch.rwt.shortcut.LaunchConfigFinder;
import org.eclipse.rap.ui.internal.launch.rwt.util.StatusUtil;

public class RWTLaunchShortcut
extends JavaLaunchShortcut {
    protected ILaunchConfigurationType getConfigurationType() {
        return RWTLaunchConfig.getType();
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration result = null;
        try {
            result = LaunchConfigCreator.fromType(type);
        }
        catch (CoreException ce) {
            StatusUtil.showCoreException(ce);
        }
        return result;
    }

    protected ILaunchConfiguration findLaunchConfiguration(IType type, ILaunchConfigurationType configType) {
        LaunchConfigFinder.LaunchConfigSelector launchConfigSelector = new LaunchConfigFinder.LaunchConfigSelector(){

            public ILaunchConfiguration select(ILaunchConfiguration[] launchConfigs) {
                return RWTLaunchShortcut.this.chooseConfiguration(Arrays.asList(launchConfigs));
            }
        };
        LaunchConfigFinder launchConfigFinder = new LaunchConfigFinder(launchConfigSelector);
        ILaunchConfiguration result = null;
        try {
            result = launchConfigFinder.forType(type);
        }
        catch (CoreException ce) {
            StatusUtil.showCoreException(ce);
        }
        return result;
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        IJavaElement[] javaElements = JavaElementUtil.adapt(elements);
        EntryPointSearchEngine engine = new EntryPointSearchEngine(context);
        return engine.search(javaElements);
    }

    protected String getTypeSelectionTitle() {
        return "Select RWT Application";
    }

    protected String getEditorEmptyMessage() {
        return "Editor does not contain an entry point.";
    }

    protected String getSelectionEmptyMessage() {
        return "Selection does not contain an entry point.";
    }
}

