/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    public static Object newInstance(ClassLoader classLoader, String className) {
        Class<?> type;
        ParamCheck.notNull(className, "className");
        ParamCheck.notNull(classLoader, "classLoader");
        try {
            type = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ClassInstantiationException("Failed to load type: " + className, cnfe);
        }
        return ClassUtil.newInstance(type);
    }

    public static <T> T newInstance(Class<T> type) {
        return ClassUtil.newInstance(type, null, null);
    }

    public static <T> T newInstance(Class<T> type, Class[] paramTypes, Object[] paramValues) {
        ParamCheck.notNull(type, "type");
        T result = null;
        try {
            result = ClassUtil.createInstance(type, paramTypes, paramValues);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (InvocationTargetException ite) {
            ClassUtil.rethrowRuntimeExceptions(ite);
            ClassUtil.throwInstantiationException(type, ite.getCause());
        }
        catch (Exception exception) {
            ClassUtil.throwInstantiationException(type, exception);
        }
        return result;
    }

    private static <T> T createInstance(Class<T> type, Class[] paramTypes, Object[] paramValues) throws Exception {
        Constructor<T> constructor = type.getDeclaredConstructor(paramTypes);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(paramValues);
    }

    private static void rethrowRuntimeExceptions(InvocationTargetException ite) {
        if (ite.getCause() instanceof RuntimeException) {
            throw (RuntimeException)ite.getCause();
        }
    }

    private static void throwInstantiationException(Class<?> type, Throwable cause) {
        String msg = "Failed to create instance of type: " + type.getName();
        throw new ClassInstantiationException(msg, cause);
    }

    private ClassUtil() {
    }
}

