/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.Locale;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rwt.RWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class NLSTab
extends ExampleTab {
    private static final String LOCALE_DATA = "locale";
    private Label lblTranslatable;

    public NLSTab(CTabFolder folder) {
        super(folder, "NLS");
    }

    protected void createStyleControls(Composite parent) {
        Label lblInfo = new Label(parent, 0);
        String info = "Select one of the locales below to be set for the current session:";
        lblInfo.setText(info);
        String text = "Default (" + RWT.getLocale().getDisplayLanguage() + ")";
        Button btnDefault = this.createLocaleButton(parent, text, null);
        btnDefault.setSelection(true);
        this.createLocaleButton(parent, "English", Locale.ENGLISH);
        this.createLocaleButton(parent, "German", Locale.GERMAN);
        this.createLocaleButton(parent, "Spanish", new Locale("es"));
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.lblTranslatable = new Label(parent, 0);
        this.updateTranslatable();
    }

    private Button createLocaleButton(Composite parent, String text, Locale locale) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Locale locale = (Locale)event.widget.getData(NLSTab.LOCALE_DATA);
                if (((Button)event.widget).getSelection()) {
                    RWT.setLocale((Locale)locale);
                    NLSTab.this.updateTranslatable();
                }
            }
        };
        Button result = new Button(parent, 16);
        result.setText(text);
        result.setData(LOCALE_DATA, (Object)locale);
        result.addSelectionListener((SelectionListener)listener);
        return result;
    }

    private void updateTranslatable() {
        this.lblTranslatable.setText(NLSTabMessages.get().TranslatableMessage);
    }

    static final class NLSTabMessages {
        private static final String BUNDLE_NAME = "org.eclipse.rap.demo.controls.NLSTabMessages";
        public String TranslatableMessage;

        public static NLSTabMessages get() {
            return (NLSTabMessages)RWT.NLS.getUTF8Encoded((String)BUNDLE_NAME, NLSTabMessages.class);
        }

        private NLSTabMessages() {
        }
    }
}

