/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treeitemkit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ITreeItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.TreeItem";
    static final String PROP_ITEM_COUNT = "itemCount";
    static final String PROP_TEXTS = "texts";
    static final String PROP_IMAGES = "images";
    static final String PROP_BACKGROUND = "background";
    static final String PROP_FOREGROUND = "foreground";
    static final String PROP_FONT = "font";
    static final String PROP_CELL_BACKGROUNDS = "cellBackgrounds";
    static final String PROP_CELL_FOREGROUNDS = "cellForegrounds";
    static final String PROP_CELL_FONTS = "cellFonts";
    static final String PROP_EXPANDED = "expanded";
    static final String PROP_CHECKED = "checked";
    static final String PROP_GRAYED = "grayed";
    private static final int DEFAULT_ITEM_COUNT = 0;

    public void preserveValues(Widget widget) {
        TreeItem item = (TreeItem)widget;
        if (TreeItemLCA.isCached(item)) {
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_ITEM_COUNT, item.getItemCount());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXTS, TreeItemLCA.getTexts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGES, TreeItemLCA.getImages(item));
            WidgetLCAUtil.preserveBackground(item, TreeItemLCA.getUserBackground(item));
            WidgetLCAUtil.preserveForeground(item, TreeItemLCA.getUserForeground(item));
            WidgetLCAUtil.preserveFont(item, TreeItemLCA.getUserFont(item));
            WidgetLCAUtil.preserveCustomVariant(item);
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_BACKGROUNDS, TreeItemLCA.getCellBackgrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_FOREGROUNDS, TreeItemLCA.getCellForegrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_FONTS, TreeItemLCA.getCellFonts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_EXPANDED, item.getExpanded());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CHECKED, item.getChecked());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_GRAYED, item.getGrayed());
        }
    }

    public void readData(Widget widget) {
        final TreeItem item = (TreeItem)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, PROP_CHECKED);
        if (value != null) {
            item.setChecked(Boolean.valueOf(value));
        }
        if (WidgetLCAUtil.wasEventSent(item, "org.eclipse.swt.events.treeExpanded")) {
            TreeItemLCA.processTreeExpandedEvent(item);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    item.setExpanded(true);
                }
            });
        }
        if (WidgetLCAUtil.wasEventSent(item, "org.eclipse.swt.events.treeCollapsed")) {
            TreeItemLCA.processTreeCollapsedEvent(item);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    item.setExpanded(false);
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        int index;
        Widget parent;
        TreeItem item = (TreeItem)widget;
        if (item.getParentItem() == null) {
            parent = item.getParent();
            index = item.getParent().indexOf(item);
        } else {
            parent = item.getParentItem();
            index = item.getParentItem().indexOf(item);
        }
        IClientObject clientObject = ClientObjectFactory.getClientObject(item);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(parent));
        clientObject.set("index", index);
    }

    public void renderChanges(Widget widget) throws IOException {
        TreeItem item = (TreeItem)widget;
        if (TreeItemLCA.isCached(item)) {
            WidgetLCAUtil.renderProperty((Widget)item, PROP_ITEM_COUNT, item.getItemCount(), 0);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_TEXTS, TreeItemLCA.getTexts(item), TreeItemLCA.getDefaultTexts(item));
            WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGES, TreeItemLCA.getImages(item), new Image[TreeItemLCA.getColumnCount(item)]);
            WidgetLCAUtil.renderBackground(item, TreeItemLCA.getUserBackground(item));
            WidgetLCAUtil.renderForeground(item, TreeItemLCA.getUserForeground(item));
            WidgetLCAUtil.renderFont(item, TreeItemLCA.getUserFont(item));
            WidgetLCAUtil.renderCustomVariant(item);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_BACKGROUNDS, TreeItemLCA.getCellBackgrounds(item), new Color[TreeItemLCA.getColumnCount(item)]);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_FOREGROUNDS, TreeItemLCA.getCellForegrounds(item), new Color[TreeItemLCA.getColumnCount(item)]);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_FONTS, TreeItemLCA.getCellFonts(item), new Font[TreeItemLCA.getColumnCount(item)]);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_EXPANDED, item.getExpanded(), false);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_CHECKED, item.getChecked(), false);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_GRAYED, item.getGrayed(), false);
        }
    }

    public void renderDispose(Widget widget) throws IOException {
        TreeItem item = (TreeItem)widget;
        ITreeItemAdapter itemAdapter = item.getAdapter(ITreeItemAdapter.class);
        if (!itemAdapter.isParentDisposed()) {
            ClientObjectFactory.getClientObject(widget).destroy();
        }
    }

    private static boolean isCached(TreeItem item) {
        Tree tree = item.getParent();
        ITreeAdapter treeAdapter = tree.getAdapter(ITreeAdapter.class);
        return treeAdapter.isCached(item);
    }

    private static String[] getTexts(TreeItem item) {
        int columnCount = TreeItemLCA.getColumnCount(item);
        String[] texts = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            texts[i] = item.getText(i);
            ++i;
        }
        return texts;
    }

    private static String[] getDefaultTexts(TreeItem item) {
        String[] result = new String[TreeItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = "";
            ++i;
        }
        return result;
    }

    private static Image[] getImages(TreeItem item) {
        int columnCount = TreeItemLCA.getColumnCount(item);
        Image[] images = new Image[columnCount];
        int i = 0;
        while (i < columnCount) {
            images[i] = item.getImage(i);
            ++i;
        }
        return images;
    }

    private static Color getUserBackground(TreeItem item) {
        IWidgetColorAdapter colorAdapter = item.getAdapter(IWidgetColorAdapter.class);
        return colorAdapter.getUserBackground();
    }

    private static Color getUserForeground(TreeItem item) {
        IWidgetColorAdapter colorAdapter = item.getAdapter(IWidgetColorAdapter.class);
        return colorAdapter.getUserForeground();
    }

    private static Font getUserFont(TreeItem item) {
        IWidgetFontAdapter fontAdapter = item.getAdapter(IWidgetFontAdapter.class);
        return fontAdapter.getUserFont();
    }

    private static Color[] getCellBackgrounds(TreeItem item) {
        ITreeItemAdapter itemAdapter = item.getAdapter(ITreeItemAdapter.class);
        return itemAdapter.getCellBackgrounds();
    }

    private static Color[] getCellForegrounds(TreeItem item) {
        ITreeItemAdapter itemAdapter = item.getAdapter(ITreeItemAdapter.class);
        return itemAdapter.getCellForegrounds();
    }

    private static Font[] getCellFonts(TreeItem item) {
        ITreeItemAdapter itemAdapter = item.getAdapter(ITreeItemAdapter.class);
        return itemAdapter.getCellFonts();
    }

    private static int getColumnCount(TreeItem item) {
        return Math.max(1, item.getParent().getColumnCount());
    }

    private static void processTreeExpandedEvent(TreeItem item) {
        if (TreeEvent.hasListener(item.getParent())) {
            TreeEvent event = new TreeEvent(item.getParent(), item, 17);
            event.processEvent();
        }
    }

    private static void processTreeCollapsedEvent(TreeItem item) {
        if (TreeEvent.hasListener(item.getParent())) {
            TreeEvent event = new TreeEvent(item.getParent(), item, 18);
            event.processEvent();
        }
    }
}

