/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.application;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.application.Application;
import org.eclipse.rwt.application.ApplicationConfiguration;
import org.eclipse.rwt.internal.application.ApplicationContext;
import org.eclipse.rwt.internal.application.SessionFailoverConfigurator;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.service.ServiceManager;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.lifecycle.IEntryPointFactory;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.rwt.resources.ResourceLoader;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationImpl
implements Application,
Adaptable {
    private final ApplicationContext applicationContext;
    private final ApplicationConfiguration configuration;

    public ApplicationImpl(ApplicationContext applicationContext, ApplicationConfiguration configuration) {
        this.applicationContext = applicationContext;
        this.configuration = configuration;
    }

    @Override
    public void setOperationMode(Application.OperationMode operationMode) {
        ParamCheck.notNull((Object)operationMode, "operationMode");
        switch (operationMode) {
            case JEE_COMPATIBILITY: {
                break;
            }
            case SWT_COMPATIBILITY: {
                this.applicationContext.getLifeCycleFactory().configure(RWTLifeCycle.class);
                break;
            }
            case SESSION_FAILOVER: {
                new SessionFailoverConfigurator(this.applicationContext).configure();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation mode: " + (Object)((Object)operationMode));
            }
        }
    }

    @Override
    public void addPhaseListener(PhaseListener phaseListener) {
        ParamCheck.notNull(phaseListener, "phaseListener");
        this.applicationContext.getPhaseListenerRegistry().add(phaseListener);
    }

    @Override
    public void setSettingStoreFactory(ISettingStoreFactory settingStoreFactory) {
        ParamCheck.notNull(settingStoreFactory, "settingStoreFactory");
        this.applicationContext.getSettingStoreManager().register(settingStoreFactory);
    }

    @Override
    public void addEntryPoint(String path, Class<? extends IEntryPoint> entryPointType, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        ParamCheck.notNull(entryPointType, "entryPointType");
        this.applicationContext.getEntryPointManager().registerByPath(path, entryPointType, properties);
    }

    @Override
    public void addEntryPoint(String path, IEntryPointFactory entryPointFactory, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        ParamCheck.notNull(entryPointFactory, "entryPointFactory");
        this.applicationContext.getEntryPointManager().registerByPath(path, entryPointFactory, properties);
    }

    public void addEntryPointByParameter(String parameter, Class<? extends IEntryPoint> type) {
        ParamCheck.notNull(parameter, "parameter");
        ParamCheck.notNull(type, "type");
        this.applicationContext.getEntryPointManager().registerByName(parameter, type);
    }

    public void addEntryPointByParameter(String parameter, IEntryPointFactory entryPointFactory) {
        ParamCheck.notNull(parameter, "parameter");
        ParamCheck.notNull(entryPointFactory, "entryPointFactory");
        this.applicationContext.getEntryPointManager().registerByName(parameter, entryPointFactory);
    }

    public void addAdapterFactory(Class<?> adaptable, AdapterFactory adapterFactory) {
        ParamCheck.notNull(adaptable, "adaptable");
        ParamCheck.notNull(adapterFactory, "adapterFactory");
        this.applicationContext.getAdapterManager().registerAdapters(adaptable, adapterFactory);
    }

    @Override
    public void addResource(IResource resource) {
        ParamCheck.notNull(resource, "resource");
        this.applicationContext.getResourceRegistry().add(resource);
    }

    @Override
    public void addServiceHandler(String serviceHandlerId, IServiceHandler serviceHandler) {
        ParamCheck.notNull(serviceHandlerId, "serviceHandlerId");
        ParamCheck.notNull(serviceHandler, "serviceHandler");
        ServiceManager serviceManager = this.applicationContext.getServiceManager();
        serviceManager.registerServiceHandler(serviceHandlerId, serviceHandler);
    }

    @Override
    public void addStyleSheet(String themeId, String styleSheetLocation) {
        this.addStyleSheet(themeId, styleSheetLocation, new ResourceLoaderImpl(this.getClassLoader()));
    }

    @Override
    public void addStyleSheet(String themeId, String styleSheetLocation, ResourceLoader resourceLoader) {
        ParamCheck.notNull(themeId, "themeId");
        ParamCheck.notNull(styleSheetLocation, "styleSheetLocation");
        ParamCheck.notNull(resourceLoader, "resourceLoader");
        StyleSheet styleSheet = this.readStyleSheet(styleSheetLocation, resourceLoader);
        ThemeManager themeManager = this.applicationContext.getThemeManager();
        Theme theme = themeManager.getTheme(themeId);
        if (theme != null) {
            theme.addStyleSheet(styleSheet);
        } else {
            themeManager.registerTheme(new Theme(themeId, "unknown", styleSheet));
        }
    }

    @Override
    public void addThemableWidget(Class<? extends Widget> widget) {
        this.addThemableWidget(widget, new ResourceLoaderImpl(widget.getClassLoader()));
    }

    public void addThemableWidget(Class<? extends Widget> widget, ResourceLoader resourceLoader) {
        ParamCheck.notNull(widget, "widget");
        ParamCheck.notNull(resourceLoader, "resourceLoader");
        this.applicationContext.getThemeManager().addThemeableWidget(widget, resourceLoader);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.applicationContext.getApplicationStore().setAttribute(name, value);
    }

    private ClassLoader getClassLoader() {
        return this.configuration.getClass().getClassLoader();
    }

    private StyleSheet readStyleSheet(String styleSheetLocation, ResourceLoader loader) {
        StyleSheet result;
        try {
            result = CssFileReader.readStyleSheet(styleSheetLocation, loader);
        }
        catch (IOException iOException) {
            String text = "Failed to read stylesheet from resource ''{0}''";
            Object[] args = new Object[]{styleSheetLocation};
            String msg = MessageFormat.format(text, args);
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result = null;
        if (adapter == ApplicationContext.class) {
            result = this.applicationContext;
        } else if (adapter == ApplicationConfiguration.class) {
            result = this.configuration;
        }
        return (T)result;
    }

    static class ResourceLoaderImpl
    implements ResourceLoader {
        private final ClassLoader loader;

        private ResourceLoaderImpl(ClassLoader loader) {
            this.loader = loader;
        }

        public InputStream getResourceAsStream(String resourceName) throws IOException {
            return this.loader.getResourceAsStream(resourceName);
        }
    }
}

