/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.junit;

import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import org.eclipse.rwt.internal.uicallback.UICallBackManager;
import org.eclipse.swt.widgets.Display;

public class RAPTestCase
extends TestCase {
    public RAPTestCase() {
    }

    public RAPTestCase(String name) {
        super(name);
    }

    public static void assertTrue(String message, boolean condition) {
        RAPTestCase.notifyClient();
        if (!condition) {
            RAPTestCase.fail((String)message);
        }
    }

    public static void assertTrue(boolean condition) {
        RAPTestCase.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        RAPTestCase.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        RAPTestCase.assertFalse(null, condition);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        RAPTestCase.notifyClient();
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        RAPTestCase.failNotEquals((String)message, (Object)expected, (Object)actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        RAPTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        RAPTestCase.notifyClient();
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new ComparisonFailure(message, expected, actual);
    }

    public static void assertEquals(String expected, String actual) {
        RAPTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        RAPTestCase.notifyClient();
        if (Double.compare(expected, actual) == 0) {
            return;
        }
        if (!(Math.abs(expected - actual) <= delta)) {
            RAPTestCase.failNotEquals((String)message, (Object)new Double(expected), (Object)new Double(actual));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        RAPTestCase.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        RAPTestCase.notifyClient();
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                RAPTestCase.failNotEquals((String)message, (Object)new Float(expected), (Object)new Float(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            RAPTestCase.failNotEquals((String)message, (Object)new Float(expected), (Object)new Float(actual));
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        RAPTestCase.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, long expected, long actual) {
        RAPTestCase.assertEquals(message, new Long(expected), new Long(actual));
    }

    public static void assertEquals(long expected, long actual) {
        RAPTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        RAPTestCase.assertEquals(message, (Object)expected, (Object)actual);
    }

    public static void assertEquals(boolean expected, boolean actual) {
        RAPTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, byte expected, byte actual) {
        RAPTestCase.assertEquals(message, new Byte(expected), new Byte(actual));
    }

    public static void assertEquals(byte expected, byte actual) {
        RAPTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, char expected, char actual) {
        RAPTestCase.assertEquals(message, new Character(expected), new Character(actual));
    }

    public static void assertEquals(char expected, char actual) {
        RAPTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, short expected, short actual) {
        RAPTestCase.assertEquals(message, new Short(expected), new Short(actual));
    }

    public static void assertEquals(short expected, short actual) {
        RAPTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, int expected, int actual) {
        RAPTestCase.assertEquals(message, new Integer(expected), new Integer(actual));
    }

    public static void assertEquals(int expected, int actual) {
        RAPTestCase.assertEquals(null, expected, actual);
    }

    public static void assertNotNull(Object object) {
        RAPTestCase.assertNotNull(null, object);
    }

    public static void assertNotNull(String message, Object object) {
        RAPTestCase.assertTrue(message, object != null);
    }

    public static void assertNull(Object object) {
        RAPTestCase.assertNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        RAPTestCase.assertTrue(message, object == null);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        RAPTestCase.notifyClient();
        if (expected == actual) {
            return;
        }
        RAPTestCase.failNotSame((String)message, (Object)expected, (Object)actual);
    }

    public static void assertSame(Object expected, Object actual) {
        RAPTestCase.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        RAPTestCase.notifyClient();
        if (expected == actual) {
            RAPTestCase.failSame((String)message);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        RAPTestCase.assertNotSame(null, expected, actual);
    }

    private static void notifyClient() {
        UICallBackManager.getInstance().releaseBlockedRequest();
        Display.getCurrent().sleep();
    }
}

