/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.SelectEditPartTracker;

public abstract class AbstractConnectionEditPart
extends AbstractGraphicalEditPart
implements ConnectionEditPart,
LayerConstants {
    private static final ConnectionAnchor DEFAULT_SOURCE_ANCHOR = new XYAnchor(new Point(10, 10));
    private static final ConnectionAnchor DEFAULT_TARGET_ANCHOR = new XYAnchor(new Point(100, 100));
    private EditPart sourceEditPart;
    private EditPart targetEditPart;

    protected void activateFigure() {
        this.getLayer("Connection Layer").add(this.getFigure());
    }

    public void addNotify() {
        this.activateFigure();
        super.addNotify();
    }

    protected IFigure createFigure() {
        return new PolylineConnection();
    }

    protected void deactivateFigure() {
        this.getLayer("Connection Layer").remove(this.getFigure());
        this.getConnectionFigure().setSourceAnchor(null);
        this.getConnectionFigure().setTargetAnchor(null);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == AccessibleAnchorProvider.class) {
            return new DefaultAccessibleAnchorProvider();
        }
        return super.getAdapter(adapter);
    }

    public Connection getConnectionFigure() {
        return (Connection)this.getFigure();
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker(this);
    }

    public EditPart getSource() {
        return this.sourceEditPart;
    }

    public EditPart getTarget() {
        return this.targetEditPart;
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        if (this.getSource() != null) {
            if (this.getSource() instanceof NodeEditPart) {
                NodeEditPart editPart = (NodeEditPart)this.getSource();
                return editPart.getSourceConnectionAnchor(this);
            }
            IFigure f = ((GraphicalEditPart)this.getSource()).getFigure();
            return new ChopboxAnchor(f);
        }
        return DEFAULT_SOURCE_ANCHOR;
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        if (this.getTarget() != null) {
            if (this.getTarget() instanceof NodeEditPart) {
                NodeEditPart editPart = (NodeEditPart)this.getTarget();
                return editPart.getTargetConnectionAnchor(this);
            }
            IFigure f = ((GraphicalEditPart)this.getTarget()).getFigure();
            return new ChopboxAnchor(f);
        }
        return DEFAULT_TARGET_ANCHOR;
    }

    public void refresh() {
        this.refreshSourceAnchor();
        this.refreshTargetAnchor();
        super.refresh();
    }

    protected void refreshSourceAnchor() {
        this.getConnectionFigure().setSourceAnchor(this.getSourceConnectionAnchor());
    }

    protected void refreshTargetAnchor() {
        this.getConnectionFigure().setTargetAnchor(this.getTargetConnectionAnchor());
    }

    public void removeNotify() {
        this.deactivateFigure();
        super.removeNotify();
    }

    public void setParent(EditPart parent) {
        boolean becomingNull;
        boolean wasNull = this.getParent() == null;
        boolean bl = becomingNull = parent == null;
        if (becomingNull && !wasNull) {
            this.removeNotify();
        }
        super.setParent(parent);
        if (wasNull && !becomingNull) {
            this.addNotify();
        }
    }

    public void setSource(EditPart editPart) {
        if (this.sourceEditPart == editPart) {
            return;
        }
        this.sourceEditPart = editPart;
        if (this.sourceEditPart != null) {
            this.setParent(this.sourceEditPart.getRoot());
        } else if (this.getTarget() == null) {
            this.setParent(null);
        }
        if (this.sourceEditPart != null && this.targetEditPart != null) {
            this.refresh();
        }
    }

    public void setTarget(EditPart editPart) {
        if (this.targetEditPart == editPart) {
            return;
        }
        this.targetEditPart = editPart;
        if (editPart != null) {
            this.setParent(editPart.getRoot());
        } else if (this.getSource() == null) {
            this.setParent(null);
        }
        if (this.sourceEditPart != null && this.targetEditPart != null) {
            this.refresh();
        }
    }

    protected final class DefaultAccessibleAnchorProvider
    implements AccessibleAnchorProvider {
        DefaultAccessibleAnchorProvider() {
        }

        public List getSourceAnchorLocations() {
            ArrayList<Point> list = new ArrayList<Point>();
            if (AbstractConnectionEditPart.this.getFigure() instanceof Connection) {
                Point p = ((Connection)AbstractConnectionEditPart.this.getFigure()).getPoints().getMidpoint();
                AbstractConnectionEditPart.this.getFigure().translateToAbsolute((Translatable)p);
                list.add(p);
            }
            return list;
        }

        public List getTargetAnchorLocations() {
            return this.getSourceAnchorLocations();
        }
    }
}

