/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.examples.logicdesigner.model.AndGate;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.examples.logicdesigner.model.Gate;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.OrGate;
import org.eclipse.gef.examples.logicdesigner.model.SimpleOutput;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.gef.examples.logicdesigner.model.XORGate;
import org.eclipse.gef.requests.CreationFactory;

public class LogicDiagramFactory {
    LogicDiagram root;

    protected static void connect(LogicSubpart e1, String t1, LogicSubpart e2, String t2) {
        Wire wire = new Wire();
        wire.setSource(e1);
        wire.setSourceTerminal(t1);
        wire.setTarget(e2);
        wire.setTargetTerminal(t2);
        wire.attachSource();
        wire.attachTarget();
    }

    public static Circuit createFullAdder() {
        Circuit circuit1 = LogicDiagramFactory.createHalfAdder();
        Circuit circuit2 = LogicDiagramFactory.createHalfAdder();
        circuit1.setLocation(new Point(2, 10));
        circuit2.setLocation(new Point(38, 90));
        Circuit circuit = new Circuit();
        circuit.setSize(new Dimension(120, 216));
        OrGate or = new OrGate();
        or.setLocation(new Point(22, 162));
        circuit.addChild(circuit1);
        circuit.addChild(circuit2);
        LogicDiagramFactory.connect(circuit, Circuit.TERMINALS_OUT[0], circuit1, Circuit.TERMINALS_IN[0]);
        LogicDiagramFactory.connect(circuit, Circuit.TERMINALS_OUT[2], circuit1, Circuit.TERMINALS_IN[3]);
        LogicDiagramFactory.connect(circuit, Circuit.TERMINALS_OUT[3], circuit2, Circuit.TERMINALS_IN[3]);
        LogicDiagramFactory.connect(circuit1, Circuit.TERMINALS_OUT[7], circuit2, Circuit.TERMINALS_IN[0]);
        circuit.addChild(or);
        LogicDiagramFactory.connect(or, SimpleOutput.TERMINAL_OUT, circuit, Circuit.TERMINALS_IN[4]);
        LogicDiagramFactory.connect(circuit1, Circuit.TERMINALS_OUT[4], or, Gate.TERMINAL_A);
        LogicDiagramFactory.connect(circuit2, Circuit.TERMINALS_OUT[4], or, Gate.TERMINAL_B);
        LogicDiagramFactory.connect(circuit2, Circuit.TERMINALS_OUT[7], circuit, Circuit.TERMINALS_IN[7]);
        return circuit;
    }

    public static Circuit createHalfAdder() {
        Circuit circuit = new Circuit();
        circuit.setSize(new Dimension(60, 70));
        AndGate and = new AndGate();
        and.setLocation(new Point(2, 12));
        XORGate xor = new XORGate();
        xor.setLocation(new Point(22, 12));
        circuit.addChild(xor);
        circuit.addChild(and);
        LogicDiagramFactory.connect(circuit, Circuit.TERMINALS_OUT[0], and, Gate.TERMINAL_A);
        LogicDiagramFactory.connect(circuit, Circuit.TERMINALS_OUT[3], and, Gate.TERMINAL_B);
        LogicDiagramFactory.connect(circuit, Circuit.TERMINALS_OUT[0], xor, Gate.TERMINAL_A);
        LogicDiagramFactory.connect(circuit, Circuit.TERMINALS_OUT[3], xor, Gate.TERMINAL_B);
        LogicDiagramFactory.connect(and, SimpleOutput.TERMINAL_OUT, circuit, Circuit.TERMINALS_IN[4]);
        LogicDiagramFactory.connect(xor, SimpleOutput.TERMINAL_OUT, circuit, Circuit.TERMINALS_IN[7]);
        return circuit;
    }

    public static Object createLargeModel() {
        LogicDiagram root = new LogicDiagram();
        LED led1 = new LED();
        led1.setValue(3);
        LED led2 = new LED();
        led2.setValue(7);
        LED led3 = new LED();
        led1.setLocation(new Point(170, 16));
        led2.setLocation(new Point(320, 16));
        led3.setLocation(new Point(245, 360));
        root.addChild(led1);
        root.addChild(led2);
        root.addChild(led3);
        Circuit circuit1 = LogicDiagramFactory.createHalfAdder();
        circuit1.setSize(new Dimension(64, 216));
        circuit1.setLocation(new Point(455, 104));
        root.addChild(circuit1);
        Circuit circuit2 = LogicDiagramFactory.createFullAdder();
        circuit2.setLocation(new Point(305, 104));
        root.addChild(circuit2);
        LogicDiagramFactory.connect(circuit1, Circuit.TERMINALS_OUT[4], circuit2, Circuit.TERMINALS_IN[3]);
        Circuit circuit3 = LogicDiagramFactory.createFullAdder();
        circuit3.setLocation(new Point(155, 104));
        root.addChild(circuit3);
        LogicDiagramFactory.connect(circuit2, Circuit.TERMINALS_OUT[4], circuit3, Circuit.TERMINALS_IN[3]);
        Circuit circuit4 = LogicDiagramFactory.createFullAdder();
        circuit4.setLocation(new Point(5, 104));
        LogicDiagramFactory.connect(led1, LED.TERMINAL_1_OUT, circuit1, Circuit.TERMINALS_IN[0]);
        LogicDiagramFactory.connect(led1, LED.TERMINAL_2_OUT, circuit2, Circuit.TERMINALS_IN[0]);
        LogicDiagramFactory.connect(led1, LED.TERMINAL_3_OUT, circuit3, Circuit.TERMINALS_IN[0]);
        LogicDiagramFactory.connect(led2, LED.TERMINAL_1_OUT, circuit1, Circuit.TERMINALS_IN[3]);
        LogicDiagramFactory.connect(led2, LED.TERMINAL_2_OUT, circuit2, Circuit.TERMINALS_IN[2]);
        LogicDiagramFactory.connect(circuit1, Circuit.TERMINALS_OUT[7], led3, LED.TERMINAL_1_IN);
        LogicDiagramFactory.connect(circuit2, Circuit.TERMINALS_OUT[7], led3, LED.TERMINAL_2_IN);
        LogicDiagramFactory.connect(circuit3, Circuit.TERMINALS_OUT[7], led3, LED.TERMINAL_3_IN);
        LogicDiagramFactory.connect(led2, LED.TERMINAL_3_OUT, circuit3, Circuit.TERMINALS_IN[2]);
        root.addChild(circuit4);
        LogicDiagramFactory.connect(led2, LED.TERMINAL_4_OUT, circuit4, Circuit.TERMINALS_IN[2]);
        LogicDiagramFactory.connect(circuit3, Circuit.TERMINALS_OUT[4], circuit4, Circuit.TERMINALS_IN[3]);
        LogicDiagramFactory.connect(led1, LED.TERMINAL_4_OUT, circuit4, Circuit.TERMINALS_IN[0]);
        LogicDiagramFactory.connect(circuit4, Circuit.TERMINALS_OUT[7], led3, LED.TERMINAL_4_IN);
        return root;
    }

    public static CreationFactory getFullAdderFactory() {
        return new CreationFactory(){

            public Object getNewObject() {
                return LogicDiagramFactory.createFullAdder();
            }

            public Object getObjectType() {
                return "Full Adder";
            }
        };
    }

    public static CreationFactory getHalfAdderFactory() {
        return new CreationFactory(){

            public Object getNewObject() {
                return LogicDiagramFactory.createHalfAdder();
            }

            public Object getObjectType() {
                return "Half Adder";
            }
        };
    }

    public Object createEmptyModel() {
        this.root = new LogicDiagram();
        return this.root;
    }

    public static Object createModel() {
        LogicDiagram root = new LogicDiagram();
        Circuit circuit1 = LogicDiagramFactory.createHalfAdder();
        circuit1.setLocation(new Point(50, 50));
        root.addChild(circuit1);
        return root;
    }

    public Object getRootElement() {
        if (this.root == null) {
            LogicDiagramFactory.createLargeModel();
        }
        return this.root;
    }
}

