/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.edit.WireBendpointEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.WireEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.WireEndpointEditPolicy;
import org.eclipse.gef.examples.logicdesigner.figures.FigureFactory;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.gef.examples.logicdesigner.model.WireBendpoint;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class WireEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    AccessibleEditPart acc;
    public static final Color alive = new Color((Device)Display.getDefault(), 30, 144, 255);
    public static final Color dead = new Color((Device)Display.getDefault(), 30, 30, 30);

    public void activate() {
        super.activate();
        this.getWire().addPropertyChangeListener(this);
    }

    public void activateFigure() {
        super.activateFigure();
        this.getFigure().addPropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new WireEndpointEditPolicy());
        this.refreshBendpointEditPolicy();
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new WireEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection connx = FigureFactory.createNewBendableWire(this.getWire());
        return connx;
    }

    public void deactivate() {
        this.getWire().removePropertyChangeListener(this);
        super.deactivate();
    }

    public void deactivateFigure() {
        this.getFigure().removePropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
        super.deactivateFigure();
    }

    public AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = LogicMessages.Wire_LabelText;
                }
            };
        }
        return this.acc;
    }

    protected Wire getWire() {
        return (Wire)this.getModel();
    }

    protected IFigure getWireFigure() {
        return this.getFigure();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("connectionRouter".equals(property)) {
            this.refreshBendpoints();
            this.refreshBendpointEditPolicy();
        }
        if ("value".equals(property)) {
            this.refreshVisuals();
        }
        if ("bendpoint".equals(property)) {
            this.refreshBendpoints();
        }
    }

    protected void refreshBendpoints() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter) {
            return;
        }
        List modelConstraint = this.getWire().getBendpoints();
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < modelConstraint.size()) {
            WireBendpoint wbp = (WireBendpoint)modelConstraint.get(i);
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(wbp.getFirstRelativeDimension(), wbp.getSecondRelativeDimension());
            rbp.setWeight((float)(i + 1) / ((float)modelConstraint.size() + 1.0f));
            figureConstraint.add(rbp);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    private void refreshBendpointEditPolicy() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", null);
        } else {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new WireBendpointEditPolicy());
        }
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
        if (this.getWire().getValue()) {
            this.getWireFigure().setForegroundColor(alive);
        } else {
            this.getWireFigure().setForegroundColor(dead);
        }
    }
}

