/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.IScrollableFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.MouseWheelHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.IScrollableEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef.editparts.ViewportExposeHelper;
import org.eclipse.gef.editparts.ViewportMouseWheelHelper;
import org.eclipse.gef.editpolicies.ScrollableSelectionFeedbackEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.ContainerHighlightEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicContainerEditPart;
import org.eclipse.gef.examples.logicdesigner.edit.LogicXYLayoutEditPolicy;
import org.eclipse.gef.examples.logicdesigner.figures.CircuitFigure;
import org.eclipse.gef.examples.logicdesigner.figures.FigureFactory;

public class CircuitEditPart
extends LogicContainerEditPart
implements IScrollableEditPart {
    private static final String SCROLLABLE_SELECTION_FEEDBACK = "SCROLLABLE_SELECTION_FEEDBACK";

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LogicXYLayoutEditPolicy((XYLayout)this.getContentPane().getLayoutManager()));
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContainerHighlightEditPolicy());
        this.installEditPolicy(SCROLLABLE_SELECTION_FEEDBACK, (EditPolicy)new ScrollableSelectionFeedbackEditPolicy());
    }

    protected IFigure createFigure() {
        return FigureFactory.createNewCircuit();
    }

    public Object getAdapter(Class key) {
        if (key == AutoexposeHelper.class) {
            return new ViewportAutoexposeHelper((GraphicalEditPart)this);
        }
        if (key == ExposeHelper.class) {
            return new ViewportExposeHelper((GraphicalEditPart)this);
        }
        if (key == AccessibleAnchorProvider.class) {
            return new AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider(this){

                public List getSourceAnchorLocations() {
                    ArrayList<Point> list = new ArrayList<Point>();
                    Vector sourceAnchors = CircuitEditPart.this.getNodeFigure().getSourceConnectionAnchors();
                    Vector targetAnchors = CircuitEditPart.this.getNodeFigure().getTargetConnectionAnchors();
                    int i = 0;
                    while (i < sourceAnchors.size()) {
                        ConnectionAnchor sourceAnchor = (ConnectionAnchor)sourceAnchors.get(i);
                        ConnectionAnchor targetAnchor = (ConnectionAnchor)targetAnchors.get(i);
                        list.add(new Rectangle(sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint()).getCenter());
                        ++i;
                    }
                    return list;
                }

                public List getTargetAnchorLocations() {
                    return this.getSourceAnchorLocations();
                }
            };
        }
        if (key == MouseWheelHelper.class) {
            return new ViewportMouseWheelHelper((GraphicalEditPart)this);
        }
        return super.getAdapter(key);
    }

    protected CircuitFigure getCircuitBoardFigure() {
        return (CircuitFigure)this.getFigure();
    }

    public IFigure getContentPane() {
        return this.getCircuitBoardFigure().getContentsPane();
    }

    public IScrollableFigure getScrollableFigure() {
        return (IScrollableFigure)this.getFigure();
    }
}

